/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.orekit.errors.OrekitException;
import org.orekit.frames.EOPHistory;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeFunction;
import org.orekit.utils.IERSConventions;

class TODProvider
implements TransformProvider {
    private static final long serialVersionUID = 20131209L;
    private final IERSConventions conventions;
    private final EOPHistory eopHistory;
    private final transient TimeFunction<Double> obliquityFunction;
    private final transient TimeFunction<double[]> nutationFunction;

    public TODProvider(IERSConventions conventions, EOPHistory eopHistory) throws OrekitException {
        this.conventions = conventions;
        this.eopHistory = eopHistory;
        this.obliquityFunction = conventions.getMeanObliquityFunction();
        this.nutationFunction = conventions.getNutationFunction();
    }

    EOPHistory getEOPHistory() {
        return this.eopHistory;
    }

    @Override
    public Transform getTransform(AbsoluteDate date) throws OrekitException {
        double[] angles = this.nutationFunction.value(date);
        double moe = this.obliquityFunction.value(date);
        double dpsi = angles[0];
        double deps = angles[1];
        if (this.eopHistory != null) {
            double[] correction = this.eopHistory.getEquinoxNutationCorrection(date);
            dpsi += correction[0];
            deps += correction[1];
        }
        double toe = moe + deps;
        Rotation r1 = new Rotation(Vector3D.PLUS_I, toe);
        Rotation r2 = new Rotation(Vector3D.PLUS_K, dpsi);
        Rotation r3 = new Rotation(Vector3D.PLUS_I, -moe);
        Rotation nutation = r1.applyTo(r2.applyTo(r3));
        return new Transform(date, nutation);
    }

    private Object writeReplace() {
        return new DataTransferObject(this.conventions, this.eopHistory);
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20131209L;
        private final IERSConventions conventions;
        private final EOPHistory eopHistory;

        public DataTransferObject(IERSConventions conventions, EOPHistory eopHistory) {
            this.conventions = conventions;
            this.eopHistory = eopHistory;
        }

        private Object readResolve() {
            try {
                return new TODProvider(this.conventions, this.eopHistory);
            }
            catch (OrekitException oe) {
                throw OrekitException.createInternalError(oe);
            }
        }
    }
}

