/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.frames.EOPHistory;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeFunction;
import org.orekit.utils.IERSConventions;

class TEMEProvider
implements TransformProvider {
    private static final long serialVersionUID = 20131209L;
    private final IERSConventions conventions;
    private final EOPHistory eopHistory;
    private final transient TimeFunction<Double> obliquityFunction;
    private final transient TimeFunction<double[]> nutationFunction;

    public TEMEProvider(IERSConventions conventions, EOPHistory eopHistory) throws OrekitException {
        this.conventions = conventions;
        this.eopHistory = eopHistory;
        this.obliquityFunction = conventions.getMeanObliquityFunction();
        this.nutationFunction = conventions.getNutationFunction();
    }

    EOPHistory getEOPHistory() {
        return this.eopHistory;
    }

    @Override
    public synchronized Transform getTransform(AbsoluteDate date) throws OrekitException {
        double eqe = this.getEquationOfEquinoxes(date);
        return new Transform(date, new Rotation(Vector3D.PLUS_K, -eqe));
    }

    private double getEquationOfEquinoxes(AbsoluteDate date) throws OrekitException {
        double[] angles = this.nutationFunction.value(date);
        double dPsi = angles[0];
        if (this.eopHistory != null) {
            double[] correction = this.eopHistory.getEquinoxNutationCorrection(date);
            dPsi += correction[0];
        }
        double moe = this.obliquityFunction.value(date);
        double eqe = dPsi * FastMath.cos((double)moe);
        return eqe + angles[2];
    }

    private Object writeReplace() {
        return new DataTransferObject(this.conventions, this.eopHistory);
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20131209L;
        private final IERSConventions conventions;
        private final EOPHistory eopHistory;

        public DataTransferObject(IERSConventions conventions, EOPHistory eopHistory) {
            this.conventions = conventions;
            this.eopHistory = eopHistory;
        }

        private Object readResolve() {
            try {
                return new TEMEProvider(this.conventions, this.eopHistory);
            }
            catch (OrekitException oe) {
                throw OrekitException.createInternalError(oe);
            }
        }
    }
}

