/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitExceptionWrapper;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.GenericTimeStampedCache;
import org.orekit.utils.TimeStampedGenerator;

public class InterpolatingTransformProvider
implements TransformProvider {
    private static final long serialVersionUID = 20140723L;
    private final TransformProvider rawProvider;
    private final CartesianDerivativesFilter cFilter;
    private final AngularDerivativesFilter aFilter;
    private final AbsoluteDate earliest;
    private final AbsoluteDate latest;
    private final double step;
    private final transient GenericTimeStampedCache<Transform> cache;

    @Deprecated
    public InterpolatingTransformProvider(TransformProvider rawProvider, boolean useVelocities, boolean useRotationRates, AbsoluteDate earliest, AbsoluteDate latest, int gridPoints, double step, int maxSlots, double maxSpan, double newSlotInterval) {
        this(rawProvider, useVelocities ? CartesianDerivativesFilter.USE_PV : CartesianDerivativesFilter.USE_P, useRotationRates ? AngularDerivativesFilter.USE_RR : AngularDerivativesFilter.USE_R, earliest, latest, gridPoints, step, maxSlots, maxSpan, newSlotInterval);
    }

    public InterpolatingTransformProvider(TransformProvider rawProvider, CartesianDerivativesFilter cFilter, AngularDerivativesFilter aFilter, AbsoluteDate earliest, AbsoluteDate latest, int gridPoints, double step, int maxSlots, double maxSpan, double newSlotInterval) {
        this.rawProvider = rawProvider;
        this.cFilter = cFilter;
        this.aFilter = aFilter;
        this.earliest = earliest;
        this.latest = latest;
        this.step = step;
        this.cache = new GenericTimeStampedCache<Transform>(gridPoints, maxSlots, maxSpan, newSlotInterval, new Generator(), Transform.class);
    }

    public TransformProvider getRawProvider() {
        return this.rawProvider;
    }

    public int getGridPoints() {
        return this.cache.getNeighborsSize();
    }

    public double getStep() {
        return this.step;
    }

    @Override
    public Transform getTransform(AbsoluteDate date) throws OrekitException {
        try {
            List<Transform> sample = this.cache.getNeighbors(date);
            return Transform.interpolate(date, this.cFilter, this.aFilter, sample);
        }
        catch (OrekitExceptionWrapper oew) {
            throw oew.getException();
        }
    }

    private Object writeReplace() {
        return new DTO(this.rawProvider, this.cFilter.getMaxOrder(), this.aFilter.getMaxOrder(), this.earliest, this.latest, this.cache.getNeighborsSize(), this.step, this.cache.getMaxSlots(), this.cache.getMaxSpan(), this.cache.getNewSlotQuantumGap());
    }

    private class Generator
    implements TimeStampedGenerator<Transform> {
        private Generator() {
        }

        @Override
        public List<Transform> generate(Transform existing, AbsoluteDate date) {
            try {
                ArrayList<Transform> generated = new ArrayList<Transform>();
                if (existing == null) {
                    for (int i = 0; i < InterpolatingTransformProvider.this.cache.getNeighborsSize(); ++i) {
                        generated.add(InterpolatingTransformProvider.this.rawProvider.getTransform(date.shiftedBy((double)i * InterpolatingTransformProvider.this.step)));
                    }
                } else {
                    AbsoluteDate t = existing.getDate();
                    if (date.compareTo(t) > 0) {
                        do {
                            t = t.shiftedBy(InterpolatingTransformProvider.this.step);
                            generated.add(generated.size(), InterpolatingTransformProvider.this.rawProvider.getTransform(t));
                        } while (t.compareTo(date) <= 0);
                    } else {
                        do {
                            t = t.shiftedBy(-InterpolatingTransformProvider.this.step);
                            generated.add(0, InterpolatingTransformProvider.this.rawProvider.getTransform(t));
                        } while (t.compareTo(date) >= 0);
                    }
                }
                return generated;
            }
            catch (OrekitException oe) {
                throw new OrekitExceptionWrapper(oe);
            }
        }
    }

    private static class DTO
    implements Serializable {
        private static final long serialVersionUID = 20140723L;
        private final TransformProvider rawProvider;
        private final int cDerivatives;
        private final int aDerivatives;
        private final AbsoluteDate earliest;
        private final AbsoluteDate latest;
        private final int gridPoints;
        private final double step;
        private final int maxSlots;
        private final double maxSpan;
        private final double newSlotInterval;

        private DTO(TransformProvider rawProvider, int cDerivatives, int aDerivatives, AbsoluteDate earliest, AbsoluteDate latest, int gridPoints, double step, int maxSlots, double maxSpan, double newSlotInterval) {
            this.rawProvider = rawProvider;
            this.cDerivatives = cDerivatives;
            this.aDerivatives = aDerivatives;
            this.earliest = earliest;
            this.latest = latest;
            this.gridPoints = gridPoints;
            this.step = step;
            this.maxSlots = maxSlots;
            this.maxSpan = maxSpan;
            this.newSlotInterval = newSlotInterval;
        }

        private Object readResolve() {
            return new InterpolatingTransformProvider(this.rawProvider, CartesianDerivativesFilter.getFilter(this.cDerivatives), AngularDerivativesFilter.getFilter(this.aDerivatives), this.earliest, this.latest, this.gridPoints, this.step, this.maxSlots, this.maxSpan, this.newSlotInterval);
        }
    }
}

