/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.frames.EOPHistory;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeFunction;

class CIRFProvider
implements TransformProvider {
    private static final long serialVersionUID = 20130806L;
    private final transient TimeFunction<double[]> xysPxy2Function;
    private final EOPHistory eopHistory;

    public CIRFProvider(EOPHistory eopHistory) throws OrekitException {
        this.xysPxy2Function = eopHistory.getConventions().getXYSpXY2Function();
        this.eopHistory = eopHistory;
    }

    EOPHistory getEOPHistory() {
        return this.eopHistory;
    }

    @Override
    public Transform getTransform(AbsoluteDate date) throws OrekitException {
        double[] xys = this.xysPxy2Function.value(date);
        double[] dxdy = this.eopHistory.getNonRotatinOriginNutationCorrection(date);
        double xCurrent = xys[0] + dxdy[0];
        double yCurrent = xys[1] + dxdy[1];
        double sCurrent = xys[2] - xCurrent * yCurrent / 2.0;
        double x2Py2 = xCurrent * xCurrent + yCurrent * yCurrent;
        double zP1 = 1.0 + FastMath.sqrt((double)(1.0 - x2Py2));
        double r = FastMath.sqrt((double)x2Py2);
        double sPe2 = 0.5 * (sCurrent + FastMath.atan2((double)yCurrent, (double)xCurrent));
        double cos = FastMath.cos((double)sPe2);
        double sin = FastMath.sin((double)sPe2);
        double xPr = xCurrent + r;
        double xPrCos = xPr * cos;
        double xPrSin = xPr * sin;
        double yCos = yCurrent * cos;
        double ySin = yCurrent * sin;
        Rotation bpn = new Rotation(zP1 * (xPrCos + ySin), -r * (yCos + xPrSin), r * (xPrCos - ySin), zP1 * (yCos - xPrSin), true);
        return new Transform(date, bpn, Vector3D.ZERO);
    }

    private Object writeReplace() {
        return new DataTransferObject(this.eopHistory);
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20131209L;
        private final EOPHistory eopHistory;

        public DataTransferObject(EOPHistory eopHistory) {
            this.eopHistory = eopHistory;
        }

        private Object readResolve() {
            try {
                return new CIRFProvider(this.eopHistory);
            }
            catch (OrekitException oe) {
                throw OrekitException.createInternalError(oe);
            }
        }
    }
}

