/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.maneuvers;

import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.geometry.euclidean.threed.FieldRotation;
import org.apache.commons.math3.geometry.euclidean.threed.FieldVector3D;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.ode.AbstractParameterizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.ForceModel;
import org.orekit.frames.Frame;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.DateDetector;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.numerical.TimeDerivativesEquations;
import org.orekit.time.AbsoluteDate;

public class ConstantThrustManeuver
extends AbstractParameterizable
implements ForceModel {
    private static final String THRUST = "thrust";
    private static final String FLOW_RATE = "flow rate";
    private boolean firing;
    private final AbsoluteDate startDate;
    private final AbsoluteDate endDate;
    private double thrust;
    private double flowRate;
    private final Vector3D direction;

    public ConstantThrustManeuver(AbsoluteDate date, double duration, double thrust, double isp, Vector3D direction) {
        super(new String[]{THRUST, FLOW_RATE});
        if (duration >= 0.0) {
            this.startDate = date;
            this.endDate = date.shiftedBy(duration);
        } else {
            this.endDate = date;
            this.startDate = this.endDate.shiftedBy(duration);
        }
        this.thrust = thrust;
        this.flowRate = -thrust / (9.80665 * isp);
        this.direction = direction.normalize();
        this.firing = false;
    }

    public double getThrust() {
        return this.thrust;
    }

    public double getISP() {
        return -this.thrust / (9.80665 * this.flowRate);
    }

    public double getFlowRate() {
        return this.flowRate;
    }

    @Override
    public void addContribution(SpacecraftState s, TimeDerivativesEquations adder) throws OrekitException {
        if (this.firing) {
            adder.addAcceleration(new Vector3D(this.thrust / s.getMass(), s.getAttitude().getRotation().applyInverseTo(this.direction)), s.getFrame());
            adder.addMassDerivative(this.flowRate);
        }
    }

    @Override
    public FieldVector3D<DerivativeStructure> accelerationDerivatives(AbsoluteDate date, Frame frame, FieldVector3D<DerivativeStructure> position, FieldVector3D<DerivativeStructure> velocity, FieldRotation<DerivativeStructure> rotation, DerivativeStructure mass) throws OrekitException {
        if (this.firing) {
            return new FieldVector3D((RealFieldElement)mass.reciprocal().multiply(this.thrust), rotation.applyInverseTo(this.direction));
        }
        int parameters = mass.getFreeParameters();
        int order = mass.getOrder();
        return new FieldVector3D((RealFieldElement)new DerivativeStructure(parameters, order, 0.0), (RealFieldElement)new DerivativeStructure(parameters, order, 0.0), (RealFieldElement)new DerivativeStructure(parameters, order, 0.0));
    }

    @Override
    public FieldVector3D<DerivativeStructure> accelerationDerivatives(SpacecraftState s, String paramName) throws OrekitException {
        this.complainIfNotSupported(paramName);
        if (this.firing) {
            if (THRUST.equals(paramName)) {
                DerivativeStructure thrustDS = new DerivativeStructure(1, 1, 0, this.thrust);
                return new FieldVector3D((RealFieldElement)thrustDS.divide(s.getMass()), s.getAttitude().getRotation().applyInverseTo(this.direction));
            }
            if (FLOW_RATE.equals(paramName)) {
                DerivativeStructure zero = new DerivativeStructure(1, 1, 0.0);
                return new FieldVector3D((RealFieldElement)zero, (RealFieldElement)zero, (RealFieldElement)zero);
            }
            throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_PARAMETER_NAME, paramName, "thrust, flow rate");
        }
        DerivativeStructure zero = new DerivativeStructure(1, 1, 0.0);
        return new FieldVector3D((RealFieldElement)zero, (RealFieldElement)zero, (RealFieldElement)zero);
    }

    @Override
    public EventDetector[] getEventsDetectors() {
        return new EventDetector[]{new DateDetector(this.startDate).withHandler(new FiringStartHandler()), new DateDetector(this.endDate).withHandler(new FiringStopHandler())};
    }

    public double getParameter(String name) throws IllegalArgumentException {
        this.complainIfNotSupported(name);
        if (name.equals(THRUST)) {
            return this.thrust;
        }
        return this.flowRate;
    }

    public void setParameter(String name, double value) throws IllegalArgumentException {
        this.complainIfNotSupported(name);
        if (name.equals(THRUST)) {
            this.thrust = value;
        } else {
            this.flowRate = value;
        }
    }

    private class FiringStopHandler
    implements EventHandler<DateDetector> {
        private FiringStopHandler() {
        }

        @Override
        public EventHandler.Action eventOccurred(SpacecraftState s, DateDetector detector, boolean increasing) {
            ConstantThrustManeuver.this.firing = false;
            return EventHandler.Action.RESET_DERIVATIVES;
        }

        @Override
        public SpacecraftState resetState(DateDetector detector, SpacecraftState oldState) {
            return oldState;
        }
    }

    private class FiringStartHandler
    implements EventHandler<DateDetector> {
        private FiringStartHandler() {
        }

        @Override
        public EventHandler.Action eventOccurred(SpacecraftState s, DateDetector detector, boolean increasing) {
            ConstantThrustManeuver.this.firing = true;
            return EventHandler.Action.RESET_DERIVATIVES;
        }

        @Override
        public SpacecraftState resetState(DateDetector detector, SpacecraftState oldState) {
            return oldState;
        }
    }
}

