/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity;

import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.geometry.euclidean.threed.FieldRotation;
import org.apache.commons.math3.geometry.euclidean.threed.FieldVector3D;
import org.apache.commons.math3.ode.AbstractParameterizable;
import org.apache.commons.math3.ode.UnknownParameterException;
import org.orekit.bodies.CelestialBody;
import org.orekit.errors.OrekitException;
import org.orekit.forces.ForceModel;
import org.orekit.forces.gravity.HolmesFeatherstoneAttractionModel;
import org.orekit.forces.gravity.SolidTidesField;
import org.orekit.forces.gravity.potential.CachedNormalizedSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.NormalizedSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.TideSystem;
import org.orekit.frames.Frame;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.numerical.TimeDerivativesEquations;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.UT1Scale;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.OrekitConfiguration;

public class SolidTides
extends AbstractParameterizable
implements ForceModel {
    public static final double DEFAULT_STEP = 600.0;
    public static final int DEFAULT_POINTS = 12;
    private final ForceModel attractionModel;

    public SolidTides(Frame centralBodyFrame, double ae, double mu, TideSystem centralTideSystem, IERSConventions conventions, UT1Scale ut1, CelestialBody ... bodies) throws OrekitException {
        this(centralBodyFrame, ae, mu, centralTideSystem, true, 600.0, 12, conventions, ut1, bodies);
    }

    public SolidTides(Frame centralBodyFrame, double ae, double mu, TideSystem centralTideSystem, boolean poleTide, double step, int nbPoints, IERSConventions conventions, UT1Scale ut1, CelestialBody ... bodies) throws OrekitException {
        super(new String[0]);
        SolidTidesField raw = new SolidTidesField(conventions.getLoveNumbers(), conventions.getTideFrequencyDependenceFunction(ut1), conventions.getPermanentTide(), poleTide ? conventions.getSolidPoleTide(ut1.getEOPHistory()) : null, centralBodyFrame, ae, mu, centralTideSystem, bodies);
        NormalizedSphericalHarmonicsProvider provider = nbPoints < 2 ? raw : new CachedNormalizedSphericalHarmonicsProvider(raw, step, nbPoints, OrekitConfiguration.getCacheSlotsNumber(), 604800.0, 43200.0);
        this.attractionModel = new HolmesFeatherstoneAttractionModel(centralBodyFrame, provider);
    }

    public double getParameter(String name) throws UnknownParameterException {
        throw new UnknownParameterException(name);
    }

    public void setParameter(String name, double value) throws UnknownParameterException {
        throw new UnknownParameterException(name);
    }

    @Override
    public void addContribution(SpacecraftState s, TimeDerivativesEquations adder) throws OrekitException {
        this.attractionModel.addContribution(s, adder);
    }

    @Override
    public FieldVector3D<DerivativeStructure> accelerationDerivatives(AbsoluteDate date, Frame frame, FieldVector3D<DerivativeStructure> position, FieldVector3D<DerivativeStructure> velocity, FieldRotation<DerivativeStructure> rotation, DerivativeStructure mass) throws OrekitException {
        return this.attractionModel.accelerationDerivatives(date, frame, position, velocity, rotation, mass);
    }

    @Override
    public FieldVector3D<DerivativeStructure> accelerationDerivatives(SpacecraftState s, String paramName) throws OrekitException {
        return this.attractionModel.accelerationDerivatives(s, paramName);
    }

    @Override
    public EventDetector[] getEventsDetectors() {
        return this.attractionModel.getEventsDetectors();
    }
}

