/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity;

import java.util.Collections;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.geometry.euclidean.threed.FieldRotation;
import org.apache.commons.math3.geometry.euclidean.threed.FieldVector3D;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.ode.AbstractParameterizable;
import org.apache.commons.math3.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.ForceModel;
import org.orekit.forces.gravity.potential.TideSystem;
import org.orekit.forces.gravity.potential.TideSystemProvider;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.numerical.Jacobianizer;
import org.orekit.propagation.numerical.ParameterConfiguration;
import org.orekit.propagation.numerical.TimeDerivativesEquations;
import org.orekit.time.AbsoluteDate;

public class DrozinerAttractionModel
extends AbstractParameterizable
implements ForceModel,
TideSystemProvider {
    private final UnnormalizedSphericalHarmonicsProvider provider;
    private double mu;
    private final Frame centralBodyFrame;
    private Jacobianizer jacobianizer;

    public DrozinerAttractionModel(Frame centralBodyFrame, UnnormalizedSphericalHarmonicsProvider provider) {
        super(new String[]{"central attraction coefficient"});
        this.provider = provider;
        this.mu = provider.getMu();
        this.centralBodyFrame = centralBodyFrame;
        this.jacobianizer = null;
    }

    public void setSteps(double hPosition, double hMu) {
        ParameterConfiguration muConfig = new ParameterConfiguration("central attraction coefficient", hMu);
        this.jacobianizer = new Jacobianizer(this, this.mu, Collections.singletonList(muConfig), hPosition);
    }

    @Override
    public TideSystem getTideSystem() {
        return this.provider.getTideSystem();
    }

    @Override
    public void addContribution(SpacecraftState s, TimeDerivativesEquations adder) throws OrekitException {
        double equatorialRadius;
        AbsoluteDate date = s.getDate();
        UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics = this.provider.onDate(date);
        Transform bodyToInertial = this.centralBodyFrame.getTransformTo(s.getFrame(), date);
        Vector3D posInBody = bodyToInertial.getInverse().transformVector(s.getPVCoordinates().getPosition());
        double xBody = posInBody.getX();
        double yBody = posInBody.getY();
        double zBody = posInBody.getZ();
        double r12 = xBody * xBody + yBody * yBody;
        double r1 = FastMath.sqrt((double)r12);
        if (r1 <= 0.1) {
            throw new OrekitException((Localizable)OrekitMessages.POLAR_TRAJECTORY, r1);
        }
        double r2 = r12 + zBody * zBody;
        double r = FastMath.sqrt((double)r2);
        if (r <= (equatorialRadius = this.provider.getAe())) {
            throw new OrekitException((Localizable)OrekitMessages.TRAJECTORY_INSIDE_BRILLOUIN_SPHERE, r);
        }
        double r3 = r2 * r;
        double aeOnr = equatorialRadius / r;
        double zOnr = zBody / r;
        double r1Onr = r1 / r;
        double mMuOnr3 = -this.mu / r3;
        double xDotDotk = xBody * mMuOnr3;
        double yDotDotk = yBody * mMuOnr3;
        double sumA = 0.0;
        double sumB = 0.0;
        double bk1 = zOnr;
        double bk0 = aeOnr * (3.0 * bk1 * bk1 - 1.0);
        double jk = -harmonics.getUnnormalizedCnm(1, 0);
        sumA += jk * (2.0 * aeOnr * bk1 - zOnr * bk0);
        sumB += jk * bk0;
        for (int k = 2; k <= this.provider.getMaxDegree(); ++k) {
            double bk2 = bk1;
            bk1 = bk0;
            double p = (1.0 + (double)k) / (double)k;
            bk0 = aeOnr * ((1.0 + p) * zOnr * bk1 - (double)k * aeOnr * bk2 / (double)(k - 1));
            double ak0 = p * aeOnr * bk1 - zOnr * bk0;
            jk = -harmonics.getUnnormalizedCnm(k, 0);
            sumA += jk * ak0;
            sumB += jk * bk0;
        }
        double p = -sumA / (r1Onr * r1Onr);
        double aX = xDotDotk * p;
        double aY = yDotDotk * p;
        double aZ = this.mu * sumB / r2;
        if (this.provider.getMaxOrder() > 0) {
            double cosL = xBody / r1;
            double sinL = yBody / r1;
            double betaKminus1 = aeOnr;
            double cosjm1L = cosL;
            double sinjm1L = sinL;
            double sinjL = sinL;
            double cosjL = cosL;
            double betaK = 0.0;
            double Bkj = 0.0;
            double Bkm1j = 3.0 * betaKminus1 * zOnr * r1Onr;
            double Bkm2j = 0.0;
            double Bkminus1kminus1 = Bkm1j;
            double c11 = harmonics.getUnnormalizedCnm(1, 1);
            double s11 = harmonics.getUnnormalizedSnm(1, 1);
            double Gkj = c11 * cosL + s11 * sinL;
            double Hkj = c11 * sinL - s11 * cosL;
            double Akj = 2.0 * r1Onr * betaKminus1 - zOnr * Bkminus1kminus1;
            double Dkj = (Akj + zOnr * Bkminus1kminus1) * 0.5;
            double sum1 = Akj * Gkj;
            double sum2 = Bkminus1kminus1 * Gkj;
            double sum3 = Dkj * Hkj;
            for (int j = 1; j <= this.provider.getMaxOrder(); ++j) {
                double innerSum1 = 0.0;
                double innerSum2 = 0.0;
                double innerSum3 = 0.0;
                for (int k = FastMath.max((int)2, (int)j); k <= this.provider.getMaxDegree(); ++k) {
                    double ckj = harmonics.getUnnormalizedCnm(k, j);
                    double skj = harmonics.getUnnormalizedSnm(k, j);
                    Gkj = ckj * cosjL + skj * sinjL;
                    Hkj = ckj * sinjL - skj * cosjL;
                    if (j <= k - 2) {
                        Bkj = aeOnr * (zOnr * Bkm1j * (2.0 * (double)k + 1.0) / (double)(k - j) - aeOnr * Bkm2j * (double)(k + j) / (double)(k - 1 - j));
                        Akj = aeOnr * Bkm1j * ((double)k + 1.0) / (double)(k - j) - zOnr * Bkj;
                    } else if (j == k - 1) {
                        betaK = aeOnr * (2.0 * (double)k - 1.0) * r1Onr * betaKminus1;
                        Bkj = aeOnr * (2.0 * (double)k + 1.0) * zOnr * Bkm1j - betaK;
                        Akj = aeOnr * ((double)k + 1.0) * Bkm1j - zOnr * Bkj;
                        betaKminus1 = betaK;
                    } else if (j == k) {
                        Bkj = (double)(2 * k + 1) * aeOnr * r1Onr * Bkminus1kminus1;
                        Akj = (double)(k + 1) * r1Onr * betaK - zOnr * Bkj;
                        Bkminus1kminus1 = Bkj;
                    }
                    Dkj = (Akj + zOnr * Bkj) * (double)j / ((double)k + 1.0);
                    Bkm2j = Bkm1j;
                    Bkm1j = Bkj;
                    innerSum1 += Akj * Gkj;
                    innerSum2 += Bkj * Gkj;
                    innerSum3 += Dkj * Hkj;
                }
                sum1 += innerSum1;
                sum2 += innerSum2;
                sum3 += innerSum3;
                sinjL = sinjm1L * cosL + cosjm1L * sinL;
                cosjL = cosjm1L * cosL - sinjm1L * sinL;
                sinjm1L = sinjL;
                cosjm1L = cosjL;
            }
            double r2Onr12 = r2 / (r1 * r1);
            double p1 = r2Onr12 * xDotDotk;
            double p2 = r2Onr12 * yDotDotk;
            aX += p1 * sum1 - p2 * sum3;
            aY += p2 * sum1 + p1 * sum3;
            aZ -= this.mu * sum2 / r2;
        }
        Vector3D accInInert = bodyToInertial.transformVector(new Vector3D(aX, aY, aZ));
        adder.addXYZAcceleration(accInInert.getX(), accInInert.getY(), accInInert.getZ());
    }

    @Override
    public FieldVector3D<DerivativeStructure> accelerationDerivatives(AbsoluteDate date, Frame frame, FieldVector3D<DerivativeStructure> position, FieldVector3D<DerivativeStructure> velocity, FieldRotation<DerivativeStructure> rotation, DerivativeStructure mass) throws OrekitException {
        if (this.jacobianizer == null) {
            throw new OrekitException((Localizable)OrekitMessages.STEPS_NOT_INITIALIZED_FOR_FINITE_DIFFERENCES, new Object[0]);
        }
        return this.jacobianizer.accelerationDerivatives(date, frame, position, velocity, rotation, mass);
    }

    @Override
    public FieldVector3D<DerivativeStructure> accelerationDerivatives(SpacecraftState s, String paramName) throws OrekitException {
        if (this.jacobianizer == null) {
            throw new OrekitException((Localizable)OrekitMessages.STEPS_NOT_INITIALIZED_FOR_FINITE_DIFFERENCES, new Object[0]);
        }
        return this.jacobianizer.accelerationDerivatives(s, paramName);
    }

    @Override
    public EventDetector[] getEventsDetectors() {
        return new EventDetector[0];
    }

    public double getParameter(String name) throws IllegalArgumentException {
        this.complainIfNotSupported(name);
        return this.mu;
    }

    public void setParameter(String name, double value) throws IllegalArgumentException {
        this.complainIfNotSupported(name);
        this.mu = value;
    }
}

