/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity;

import java.util.Collections;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.geometry.euclidean.threed.FieldRotation;
import org.apache.commons.math3.geometry.euclidean.threed.FieldVector3D;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.ode.AbstractParameterizable;
import org.apache.commons.math3.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.ForceModel;
import org.orekit.forces.gravity.potential.TideSystem;
import org.orekit.forces.gravity.potential.TideSystemProvider;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.numerical.Jacobianizer;
import org.orekit.propagation.numerical.ParameterConfiguration;
import org.orekit.propagation.numerical.TimeDerivativesEquations;
import org.orekit.time.AbsoluteDate;

public class CunninghamAttractionModel
extends AbstractParameterizable
implements ForceModel,
TideSystemProvider {
    private final UnnormalizedSphericalHarmonicsProvider provider;
    private double mu;
    private final Frame bodyFrame;
    private Jacobianizer jacobianizer;

    public CunninghamAttractionModel(Frame centralBodyFrame, UnnormalizedSphericalHarmonicsProvider provider) {
        super(new String[]{"central attraction coefficient"});
        this.provider = provider;
        this.mu = provider.getMu();
        this.bodyFrame = centralBodyFrame;
        this.jacobianizer = null;
    }

    public void setSteps(double hPosition, double hMu) {
        ParameterConfiguration muConfig = new ParameterConfiguration("central attraction coefficient", hMu);
        this.jacobianizer = new Jacobianizer(this, this.mu, Collections.singletonList(muConfig), hPosition);
    }

    @Override
    public TideSystem getTideSystem() {
        return this.provider.getTideSystem();
    }

    @Override
    public void addContribution(SpacecraftState s, TimeDerivativesEquations adder) throws OrekitException {
        double equatorialRadius;
        double z;
        double z2;
        double y;
        double y2;
        AbsoluteDate date = s.getDate();
        UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics = this.provider.onDate(date);
        Transform fromBodyFrame = this.bodyFrame.getTransformTo(s.getFrame(), date);
        Transform toBodyFrame = fromBodyFrame.getInverse();
        Vector3D relative = toBodyFrame.transformPosition(s.getPVCoordinates().getPosition());
        double x = relative.getX();
        double x2 = x * x;
        double r2 = x2 + (y2 = (y = relative.getY()) * y) + (z2 = (z = relative.getZ()) * z);
        double r = FastMath.sqrt((double)r2);
        if (r <= (equatorialRadius = this.provider.getAe())) {
            throw new OrekitException((Localizable)OrekitMessages.TRAJECTORY_INSIDE_BRILLOUIN_SPHERE, r);
        }
        double onR2 = 1.0 / r2;
        double onR3 = onR2 / r;
        double rEqOnR2 = equatorialRadius / r2;
        double rEqOnR4 = rEqOnR2 / r2;
        double rEq2OnR2 = equatorialRadius * rEqOnR2;
        double cmx = -x * rEqOnR2;
        double cmy = -y * rEqOnR2;
        double cmz = -z * rEqOnR2;
        double dx = -2.0 * cmx;
        double dy = -2.0 * cmy;
        double dz = -2.0 * cmz;
        double dcmxdx = (x2 - y2 - z2) * rEqOnR4;
        double dcmxdy = dx * y * onR2;
        double dcmxdz = dx * z * onR2;
        double dcmydy = (y2 - x2 - z2) * rEqOnR4;
        double dcmydz = dy * z * onR2;
        double dcmzdz = (z2 - x2 - y2) * rEqOnR4;
        double ddxdx = -2.0 * dcmxdx;
        double ddxdy = -2.0 * dcmxdy;
        double ddxdz = -2.0 * dcmxdz;
        double ddydy = -2.0 * dcmydy;
        double ddydz = -2.0 * dcmydz;
        double ddzdz = -2.0 * dcmzdz;
        double donr2dx = -dx * rEqOnR2;
        double donr2dy = -dy * rEqOnR2;
        double donr2dz = -dz * rEqOnR2;
        double vrn = 0.0;
        double vin = 0.0;
        double vrd = 1.0 / (equatorialRadius * r);
        double vid = 0.0;
        double vrn1 = 0.0;
        double vin1 = 0.0;
        double vrn2 = 0.0;
        double vin2 = 0.0;
        double gradXVrn = 0.0;
        double gradXVin = 0.0;
        double gradXVrd = -x * onR3 / equatorialRadius;
        double gradXVid = 0.0;
        double gradXVrn1 = 0.0;
        double gradXVin1 = 0.0;
        double gradXVrn2 = 0.0;
        double gradXVin2 = 0.0;
        double gradYVrn = 0.0;
        double gradYVin = 0.0;
        double gradYVrd = -y * onR3 / equatorialRadius;
        double gradYVid = 0.0;
        double gradYVrn1 = 0.0;
        double gradYVin1 = 0.0;
        double gradYVrn2 = 0.0;
        double gradYVin2 = 0.0;
        double gradZVrn = 0.0;
        double gradZVin = 0.0;
        double gradZVrd = -z * onR3 / equatorialRadius;
        double gradZVid = 0.0;
        double gradZVrn1 = 0.0;
        double gradZVin1 = 0.0;
        double gradZVrn2 = 0.0;
        double gradZVin2 = 0.0;
        double vdX = 0.0;
        double vdY = 0.0;
        double vdZ = 0.0;
        for (int m = 0; m <= this.provider.getMaxOrder(); ++m) {
            double cx = cmx;
            double cy = cmy;
            double cz = cmz;
            double dcxdx = dcmxdx;
            double dcxdy = dcmxdy;
            double dcxdz = dcmxdz;
            double dcydy = dcmydy;
            double dcydz = dcmydz;
            double dczdz = dcmzdz;
            for (int n = m; n <= this.provider.getMaxDegree(); ++n) {
                if (n == m) {
                    vrn = equatorialRadius * vrd;
                    vin = equatorialRadius * vid;
                    gradXVrn = equatorialRadius * gradXVrd;
                    gradXVin = equatorialRadius * gradXVid;
                    gradYVrn = equatorialRadius * gradYVrd;
                    gradYVin = equatorialRadius * gradYVid;
                    gradZVrn = equatorialRadius * gradZVrd;
                    gradZVin = equatorialRadius * gradZVid;
                    double tmpGradXVrd = (cx + dx) * gradXVrd - (cy + dy) * gradXVid + (dcxdx + ddxdx) * vrd - (dcxdy + ddxdy) * vid;
                    gradXVid = (cy + dy) * gradXVrd + (cx + dx) * gradXVid + (dcxdy + ddxdy) * vrd + (dcxdx + ddxdx) * vid;
                    gradXVrd = tmpGradXVrd;
                    double tmpGradYVrd = (cx + dx) * gradYVrd - (cy + dy) * gradYVid + (dcxdy + ddxdy) * vrd - (dcydy + ddydy) * vid;
                    gradYVid = (cy + dy) * gradYVrd + (cx + dx) * gradYVid + (dcydy + ddydy) * vrd + (dcxdy + ddxdy) * vid;
                    gradYVrd = tmpGradYVrd;
                    double tmpGradZVrd = (cx + dx) * gradZVrd - (cy + dy) * gradZVid + (dcxdz + ddxdz) * vrd - (dcydz + ddydz) * vid;
                    gradZVid = (cy + dy) * gradZVrd + (cx + dx) * gradZVid + (dcydz + ddydz) * vrd + (dcxdz + ddxdz) * vid;
                    gradZVrd = tmpGradZVrd;
                    double tmpVrd = (cx + dx) * vrd - (cy + dy) * vid;
                    vid = (cy + dy) * vrd + (cx + dx) * vid;
                    vrd = tmpVrd;
                } else if (n == m + 1) {
                    vrn = cz * vrn1;
                    vin = cz * vin1;
                    gradXVrn = cz * gradXVrn1 + dcxdz * vrn1;
                    gradXVin = cz * gradXVin1 + dcxdz * vin1;
                    gradYVrn = cz * gradYVrn1 + dcydz * vrn1;
                    gradYVin = cz * gradYVin1 + dcydz * vin1;
                    gradZVrn = cz * gradZVrn1 + dczdz * vrn1;
                    gradZVin = cz * gradZVin1 + dczdz * vin1;
                } else {
                    double inv = 1.0 / (double)(n - m);
                    double coeff = (double)(n + m) - 1.0;
                    vrn = (cz * vrn1 - coeff * rEq2OnR2 * vrn2) * inv;
                    vin = (cz * vin1 - coeff * rEq2OnR2 * vin2) * inv;
                    gradXVrn = (cz * gradXVrn1 - coeff * rEq2OnR2 * gradXVrn2 + dcxdz * vrn1 - coeff * donr2dx * vrn2) * inv;
                    gradXVin = (cz * gradXVin1 - coeff * rEq2OnR2 * gradXVin2 + dcxdz * vin1 - coeff * donr2dx * vin2) * inv;
                    gradYVrn = (cz * gradYVrn1 - coeff * rEq2OnR2 * gradYVrn2 + dcydz * vrn1 - coeff * donr2dy * vrn2) * inv;
                    gradYVin = (cz * gradYVin1 - coeff * rEq2OnR2 * gradYVin2 + dcydz * vin1 - coeff * donr2dy * vin2) * inv;
                    gradZVrn = (cz * gradZVrn1 - coeff * rEq2OnR2 * gradZVrn2 + dczdz * vrn1 - coeff * donr2dz * vrn2) * inv;
                    gradZVin = (cz * gradZVin1 - coeff * rEq2OnR2 * gradZVin2 + dczdz * vin1 - coeff * donr2dz * vin2) * inv;
                }
                cx += dx;
                cy += dy;
                cz += dz;
                dcxdx += ddxdx;
                dcxdy += ddxdy;
                dcxdz += ddxdz;
                dcydy += ddydy;
                dcydz += ddydz;
                dczdz += ddzdz;
                vrn2 = vrn1;
                vin2 = vin1;
                gradXVrn2 = gradXVrn1;
                gradXVin2 = gradXVin1;
                gradYVrn2 = gradYVrn1;
                gradYVin2 = gradYVin1;
                gradZVrn2 = gradZVrn1;
                gradZVin2 = gradZVin1;
                vrn1 = vrn;
                vin1 = vin;
                gradXVrn1 = gradXVrn;
                gradXVin1 = gradXVin;
                gradYVrn1 = gradYVrn;
                gradYVin1 = gradYVin;
                gradZVrn1 = gradZVrn;
                gradZVin1 = gradZVin;
                if (n <= 0) continue;
                double cnm = harmonics.getUnnormalizedCnm(n, m);
                double snm = harmonics.getUnnormalizedSnm(n, m);
                vdX += cnm * gradXVrn + snm * gradXVin;
                vdY += cnm * gradYVrn + snm * gradYVin;
                vdZ += cnm * gradZVrn + snm * gradZVin;
            }
            cmx += dx;
            cmy += dy;
            cmz += dz;
            dcmxdx += ddxdx;
            dcmxdy += ddxdy;
            dcmxdz += ddxdz;
            dcmydy += ddydy;
            dcmydz += ddydz;
            dcmzdz += ddzdz;
        }
        Vector3D acceleration = fromBodyFrame.transformVector(new Vector3D(this.mu * vdX, this.mu * vdY, this.mu * vdZ));
        adder.addXYZAcceleration(acceleration.getX(), acceleration.getY(), acceleration.getZ());
    }

    @Override
    public FieldVector3D<DerivativeStructure> accelerationDerivatives(AbsoluteDate date, Frame frame, FieldVector3D<DerivativeStructure> position, FieldVector3D<DerivativeStructure> velocity, FieldRotation<DerivativeStructure> rotation, DerivativeStructure mass) throws OrekitException {
        if (this.jacobianizer == null) {
            throw new OrekitException((Localizable)OrekitMessages.STEPS_NOT_INITIALIZED_FOR_FINITE_DIFFERENCES, new Object[0]);
        }
        return this.jacobianizer.accelerationDerivatives(date, frame, position, velocity, rotation, mass);
    }

    @Override
    public FieldVector3D<DerivativeStructure> accelerationDerivatives(SpacecraftState s, String paramName) throws OrekitException {
        if (this.jacobianizer == null) {
            throw new OrekitException((Localizable)OrekitMessages.STEPS_NOT_INITIALIZED_FOR_FINITE_DIFFERENCES, new Object[0]);
        }
        return this.jacobianizer.accelerationDerivatives(s, paramName);
    }

    @Override
    public EventDetector[] getEventsDetectors() {
        return new EventDetector[0];
    }

    public double getParameter(String name) throws IllegalArgumentException {
        this.complainIfNotSupported(name);
        return this.mu;
    }

    public void setParameter(String name, double value) throws IllegalArgumentException {
        this.complainIfNotSupported(name);
        this.mu = value;
    }
}

