/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.drag;

import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.FieldRotation;
import org.apache.commons.math3.geometry.euclidean.threed.FieldVector3D;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.ode.AbstractParameterizable;
import org.orekit.errors.OrekitException;
import org.orekit.forces.ForceModel;
import org.orekit.forces.drag.Atmosphere;
import org.orekit.forces.drag.DragSensitive;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.numerical.TimeDerivativesEquations;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;

public class DragForce
extends AbstractParameterizable
implements ForceModel {
    private final Atmosphere atmosphere;
    private final DragSensitive spacecraft;

    public DragForce(Atmosphere atmosphere, DragSensitive spacecraft) {
        super(new String[]{"drag coefficient"});
        this.atmosphere = atmosphere;
        this.spacecraft = spacecraft;
    }

    @Override
    public void addContribution(SpacecraftState s, TimeDerivativesEquations adder) throws OrekitException {
        AbsoluteDate date = s.getDate();
        Frame frame = s.getFrame();
        Vector3D position = s.getPVCoordinates().getPosition();
        double rho = this.atmosphere.getDensity(date, position, frame);
        Vector3D vAtm = this.atmosphere.getVelocity(date, position, frame);
        Vector3D relativeVelocity = vAtm.subtract((Vector)s.getPVCoordinates().getVelocity());
        adder.addAcceleration(this.spacecraft.dragAcceleration(date, frame, position, s.getAttitude().getRotation(), s.getMass(), rho, relativeVelocity), frame);
    }

    @Override
    public EventDetector[] getEventsDetectors() {
        return new EventDetector[0];
    }

    public double getParameter(String name) throws IllegalArgumentException {
        this.complainIfNotSupported(name);
        return this.spacecraft.getDragCoefficient();
    }

    public void setParameter(String name, double value) throws IllegalArgumentException {
        this.complainIfNotSupported(name);
        this.spacecraft.setDragCoefficient(value);
    }

    @Override
    public FieldVector3D<DerivativeStructure> accelerationDerivatives(AbsoluteDate date, Frame frame, FieldVector3D<DerivativeStructure> position, FieldVector3D<DerivativeStructure> velocity, FieldRotation<DerivativeStructure> rotation, DerivativeStructure mass) throws OrekitException {
        int parameters = mass.getFreeParameters();
        int order = mass.getOrder();
        Frame atmFrame = this.atmosphere.getFrame();
        Transform toBody = frame.getTransformTo(atmFrame, date);
        FieldVector3D<DerivativeStructure> posBodyDS = toBody.transformPosition(position);
        Vector3D posBody = posBodyDS.toVector3D();
        double rho = this.atmosphere.getDensity(date, posBody, atmFrame);
        Vector3D vAtmBody = this.atmosphere.getVelocity(date, posBody, atmFrame);
        FieldVector3D vAtmBodyDS = new FieldVector3D((RealFieldElement)new DerivativeStructure(parameters, order, vAtmBody.getX()), (RealFieldElement)new DerivativeStructure(parameters, order, vAtmBody.getY()), (RealFieldElement)new DerivativeStructure(parameters, order, vAtmBody.getZ()));
        FieldPVCoordinates<DerivativeStructure> pvAtmBody = new FieldPVCoordinates<DerivativeStructure>(posBodyDS, vAtmBodyDS);
        FieldPVCoordinates<DerivativeStructure> pvAtm = toBody.getInverse().transformPVCoordinates(pvAtmBody);
        FieldVector3D relativeVelocity = pvAtm.getVelocity().subtract(velocity);
        return this.spacecraft.dragAcceleration(date, frame, position, rotation, mass, rho, (FieldVector3D<DerivativeStructure>)relativeVelocity);
    }

    @Override
    public FieldVector3D<DerivativeStructure> accelerationDerivatives(SpacecraftState s, String paramName) throws OrekitException {
        this.complainIfNotSupported(paramName);
        AbsoluteDate date = s.getDate();
        Frame frame = s.getFrame();
        Vector3D position = s.getPVCoordinates().getPosition();
        double rho = this.atmosphere.getDensity(date, position, frame);
        Vector3D vAtm = this.atmosphere.getVelocity(date, position, frame);
        Vector3D relativeVelocity = vAtm.subtract((Vector)s.getPVCoordinates().getVelocity());
        return this.spacecraft.dragAcceleration(date, frame, position, s.getAttitude().getRotation(), s.getMass(), rho, relativeVelocity, paramName);
    }
}

