/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces;

import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.geometry.euclidean.threed.FieldRotation;
import org.apache.commons.math3.geometry.euclidean.threed.FieldVector3D;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.drag.DragSensitive;
import org.orekit.forces.radiation.RadiationSensitive;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;

public class SphericalSpacecraft
implements RadiationSensitive,
DragSensitive {
    private final double crossSection;
    private double dragCoeff;
    private double absorptionCoeff;
    private double specularReflectionCoeff;

    public SphericalSpacecraft(double crossSection, double dragCoeff, double absorptionCoeff, double reflectionCoeff) {
        this.crossSection = crossSection;
        this.dragCoeff = dragCoeff;
        this.absorptionCoeff = absorptionCoeff;
        this.specularReflectionCoeff = reflectionCoeff;
    }

    @Override
    public Vector3D dragAcceleration(AbsoluteDate date, Frame frame, Vector3D position, Rotation rotation, double mass, double density, Vector3D relativeVelocity) {
        return new Vector3D(relativeVelocity.getNorm() * density * this.dragCoeff * this.crossSection / (2.0 * mass), relativeVelocity);
    }

    @Override
    public FieldVector3D<DerivativeStructure> dragAcceleration(AbsoluteDate date, Frame frame, FieldVector3D<DerivativeStructure> position, FieldRotation<DerivativeStructure> rotation, DerivativeStructure mass, double density, FieldVector3D<DerivativeStructure> relativeVelocity) {
        return new FieldVector3D((RealFieldElement)((DerivativeStructure)relativeVelocity.getNorm()).multiply(density * this.dragCoeff * this.crossSection / 2.0).divide(mass), relativeVelocity);
    }

    @Override
    public FieldVector3D<DerivativeStructure> dragAcceleration(AbsoluteDate date, Frame frame, Vector3D position, Rotation rotation, double mass, double density, Vector3D relativeVelocity, String paramName) throws OrekitException {
        if (!"drag coefficient".equals(paramName)) {
            throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_PARAMETER_NAME, paramName, "drag coefficient");
        }
        DerivativeStructure dragCoeffDS = new DerivativeStructure(1, 1, 0, this.dragCoeff);
        return new FieldVector3D((RealFieldElement)dragCoeffDS.multiply(relativeVelocity.getNorm() * density * this.crossSection / (2.0 * mass)), relativeVelocity);
    }

    @Override
    public Vector3D radiationPressureAcceleration(AbsoluteDate date, Frame frame, Vector3D position, Rotation rotation, double mass, Vector3D flux) {
        double kP = this.crossSection * (1.0 + 4.0 * (1.0 - this.absorptionCoeff) * (1.0 - this.specularReflectionCoeff) / 9.0);
        return new Vector3D(kP / mass, flux);
    }

    @Override
    public FieldVector3D<DerivativeStructure> radiationPressureAcceleration(AbsoluteDate date, Frame frame, FieldVector3D<DerivativeStructure> position, FieldRotation<DerivativeStructure> rotation, DerivativeStructure mass, FieldVector3D<DerivativeStructure> flux) {
        double kP = this.crossSection * (1.0 + 4.0 * (1.0 - this.absorptionCoeff) * (1.0 - this.specularReflectionCoeff) / 9.0);
        return new FieldVector3D((RealFieldElement)mass.reciprocal().multiply(kP), flux);
    }

    @Override
    public FieldVector3D<DerivativeStructure> radiationPressureAcceleration(AbsoluteDate date, Frame frame, Vector3D position, Rotation rotation, double mass, Vector3D flux, String paramName) throws OrekitException {
        DerivativeStructure specularReflectionCoeffDS;
        DerivativeStructure absorptionCoeffDS;
        if ("absorption coefficient".equals(paramName)) {
            absorptionCoeffDS = new DerivativeStructure(1, 1, 0, this.absorptionCoeff);
            specularReflectionCoeffDS = new DerivativeStructure(1, 1, this.specularReflectionCoeff);
        } else if ("reflection coefficient".equals(paramName)) {
            absorptionCoeffDS = new DerivativeStructure(1, 1, this.absorptionCoeff);
            specularReflectionCoeffDS = new DerivativeStructure(1, 1, 0, this.specularReflectionCoeff);
        } else {
            throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_PARAMETER_NAME, paramName, "absorption coefficient, reflection coefficient");
        }
        DerivativeStructure kP = absorptionCoeffDS.subtract(1.0).multiply(specularReflectionCoeffDS.subtract(1.0)).multiply(0.4444444444444444).add(1.0).multiply(this.crossSection);
        return new FieldVector3D((RealFieldElement)kP.divide(mass), flux);
    }

    @Override
    public void setDragCoefficient(double value) {
        this.dragCoeff = value;
    }

    @Override
    public double getDragCoefficient() {
        return this.dragCoeff;
    }

    @Override
    public void setAbsorptionCoefficient(double value) {
        this.absorptionCoeff = value;
    }

    @Override
    public double getAbsorptionCoefficient() {
        return this.absorptionCoeff;
    }

    @Override
    public void setReflectionCoefficient(double value) {
        this.specularReflectionCoeff = value;
    }

    @Override
    public double getReflectionCoefficient() {
        return this.specularReflectionCoeff;
    }
}

