/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.FieldRotation;
import org.apache.commons.math3.geometry.euclidean.threed.FieldVector3D;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.drag.DragSensitive;
import org.orekit.forces.radiation.RadiationSensitive;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinatesProvider;

public class BoxAndSolarArraySpacecraft
implements RadiationSensitive,
DragSensitive {
    private final List<Facet> facets;
    private final double solarArrayArea;
    private final AbsoluteDate referenceDate;
    private final double rotationRate;
    private final Vector3D saX;
    private final Vector3D saY;
    private final Vector3D saZ;
    private double dragCoeff;
    private double absorptionCoeff;
    private double specularReflectionCoeff;
    private double diffuseReflectionCoeff;
    private final PVCoordinatesProvider sun;

    public BoxAndSolarArraySpacecraft(double xLength, double yLength, double zLength, PVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, double dragCoeff, double absorptionCoeff, double reflectionCoeff) {
        this(BoxAndSolarArraySpacecraft.simpleBoxFacets(xLength, yLength, zLength), sun, solarArrayArea, solarArrayAxis, dragCoeff, absorptionCoeff, reflectionCoeff);
    }

    public BoxAndSolarArraySpacecraft(Facet[] facets, PVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, double dragCoeff, double absorptionCoeff, double reflectionCoeff) {
        this.facets = BoxAndSolarArraySpacecraft.filter(facets);
        this.sun = sun;
        this.solarArrayArea = solarArrayArea;
        this.referenceDate = null;
        this.rotationRate = 0.0;
        this.saZ = solarArrayAxis.normalize();
        this.saY = null;
        this.saX = null;
        this.dragCoeff = dragCoeff;
        this.absorptionCoeff = absorptionCoeff;
        this.specularReflectionCoeff = reflectionCoeff;
        this.diffuseReflectionCoeff = 1.0 - (absorptionCoeff + reflectionCoeff);
    }

    public BoxAndSolarArraySpacecraft(double xLength, double yLength, double zLength, PVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, AbsoluteDate referenceDate, Vector3D referenceNormal, double rotationRate, double dragCoeff, double absorptionCoeff, double reflectionCoeff) {
        this(BoxAndSolarArraySpacecraft.simpleBoxFacets(xLength, yLength, zLength), sun, solarArrayArea, solarArrayAxis, referenceDate, referenceNormal, rotationRate, dragCoeff, absorptionCoeff, reflectionCoeff);
    }

    public BoxAndSolarArraySpacecraft(Facet[] facets, PVCoordinatesProvider sun, double solarArrayArea, Vector3D solarArrayAxis, AbsoluteDate referenceDate, Vector3D referenceNormal, double rotationRate, double dragCoeff, double absorptionCoeff, double reflectionCoeff) {
        this.facets = BoxAndSolarArraySpacecraft.filter((Facet[])facets.clone());
        this.sun = sun;
        this.solarArrayArea = solarArrayArea;
        this.referenceDate = referenceDate;
        this.rotationRate = rotationRate;
        this.saZ = solarArrayAxis.normalize();
        this.saY = Vector3D.crossProduct((Vector3D)this.saZ, (Vector3D)referenceNormal).normalize();
        this.saX = Vector3D.crossProduct((Vector3D)this.saY, (Vector3D)this.saZ);
        this.dragCoeff = dragCoeff;
        this.absorptionCoeff = absorptionCoeff;
        this.specularReflectionCoeff = reflectionCoeff;
        this.diffuseReflectionCoeff = 1.0 - (absorptionCoeff + reflectionCoeff);
    }

    public synchronized Vector3D getNormal(AbsoluteDate date, Frame frame, Vector3D position, Rotation rotation) throws OrekitException {
        if (this.referenceDate != null) {
            double alpha = this.rotationRate * date.durationFrom(this.referenceDate);
            return new Vector3D(FastMath.cos((double)alpha), this.saX, FastMath.sin((double)alpha), this.saY);
        }
        Vector3D sunInert = this.sun.getPVCoordinates(date, frame).getPosition().subtract((Vector)position).normalize();
        Vector3D sunSpacecraft = rotation.applyTo(sunInert);
        double d = Vector3D.dotProduct((Vector3D)sunSpacecraft, (Vector3D)this.saZ);
        double f = 1.0 - d * d;
        if (f < Precision.EPSILON) {
            return this.saZ.orthogonal();
        }
        double s = 1.0 / FastMath.sqrt((double)f);
        return new Vector3D(s, sunSpacecraft, -s * d, this.saZ);
    }

    public synchronized FieldVector3D<DerivativeStructure> getNormal(AbsoluteDate date, Frame frame, FieldVector3D<DerivativeStructure> position, FieldRotation<DerivativeStructure> rotation) throws OrekitException {
        DerivativeStructure one = (DerivativeStructure)((DerivativeStructure)position.getX()).getField().getOne();
        if (this.referenceDate != null) {
            DerivativeStructure alpha = one.multiply(this.rotationRate * date.durationFrom(this.referenceDate));
            return new FieldVector3D((RealFieldElement)alpha.cos(), this.saX, (RealFieldElement)alpha.sin(), this.saY);
        }
        FieldVector3D sunInert = position.subtract(this.sun.getPVCoordinates(date, frame).getPosition()).negate().normalize();
        FieldVector3D sunSpacecraft = rotation.applyTo(sunInert);
        DerivativeStructure d = (DerivativeStructure)FieldVector3D.dotProduct((FieldVector3D)sunSpacecraft, (Vector3D)this.saZ);
        DerivativeStructure f = d.multiply(d).subtract(1.0).negate();
        if (f.getValue() < Precision.EPSILON) {
            return new FieldVector3D((RealFieldElement)one, this.saZ.orthogonal());
        }
        DerivativeStructure s = f.sqrt().reciprocal();
        return new FieldVector3D((RealFieldElement)s, sunSpacecraft).subtract(new FieldVector3D((RealFieldElement)s.multiply(d), this.saZ));
    }

    @Override
    public Vector3D dragAcceleration(AbsoluteDate date, Frame frame, Vector3D position, Rotation rotation, double mass, double density, Vector3D relativeVelocity) throws OrekitException {
        Vector3D v = rotation.applyTo(relativeVelocity);
        Vector3D solarArrayFacet = new Vector3D(this.solarArrayArea, this.getNormal(date, frame, position, rotation));
        double sv = FastMath.abs((double)Vector3D.dotProduct((Vector3D)solarArrayFacet, (Vector3D)v));
        for (Facet facet : this.facets) {
            double dot = Vector3D.dotProduct((Vector3D)facet.getNormal(), (Vector3D)v);
            if (!(dot < 0.0)) continue;
            sv -= facet.getArea() * dot;
        }
        return new Vector3D(sv * density * this.dragCoeff / (2.0 * mass), relativeVelocity);
    }

    @Override
    public FieldVector3D<DerivativeStructure> dragAcceleration(AbsoluteDate date, Frame frame, FieldVector3D<DerivativeStructure> position, FieldRotation<DerivativeStructure> rotation, DerivativeStructure mass, double density, FieldVector3D<DerivativeStructure> relativeVelocity) throws OrekitException {
        FieldVector3D v = rotation.applyTo(relativeVelocity);
        FieldVector3D solarArrayFacet = new FieldVector3D(this.solarArrayArea, this.getNormal(date, frame, position, rotation));
        DerivativeStructure sv = ((DerivativeStructure)FieldVector3D.dotProduct((FieldVector3D)v, (FieldVector3D)solarArrayFacet)).abs();
        for (Facet facet : this.facets) {
            DerivativeStructure dot = (DerivativeStructure)FieldVector3D.dotProduct((FieldVector3D)v, (Vector3D)facet.getNormal());
            if (!(dot.getValue() < 0.0)) continue;
            sv = sv.subtract(dot.multiply(facet.getArea()));
        }
        return new FieldVector3D((RealFieldElement)sv.multiply(density * this.dragCoeff / 2.0).divide(mass), relativeVelocity);
    }

    @Override
    public FieldVector3D<DerivativeStructure> dragAcceleration(AbsoluteDate date, Frame frame, Vector3D position, Rotation rotation, double mass, double density, Vector3D relativeVelocity, String paramName) throws OrekitException {
        if (!"drag coefficient".equals(paramName)) {
            throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_PARAMETER_NAME, paramName, "drag coefficient");
        }
        DerivativeStructure dragCoeffDS = new DerivativeStructure(1, 1, 0, this.dragCoeff);
        Vector3D v = rotation.applyTo(relativeVelocity);
        Vector3D solarArrayFacet = new Vector3D(this.solarArrayArea, this.getNormal(date, frame, position, rotation));
        double sv = FastMath.abs((double)Vector3D.dotProduct((Vector3D)solarArrayFacet, (Vector3D)v));
        for (Facet facet : this.facets) {
            double dot = Vector3D.dotProduct((Vector3D)facet.getNormal(), (Vector3D)v);
            if (!(dot < 0.0)) continue;
            sv -= facet.getArea() * dot;
        }
        return new FieldVector3D((RealFieldElement)dragCoeffDS.multiply(sv * density / (2.0 * mass)), relativeVelocity);
    }

    @Override
    public Vector3D radiationPressureAcceleration(AbsoluteDate date, Frame frame, Vector3D position, Rotation rotation, double mass, Vector3D flux) throws OrekitException {
        if (flux.getNormSq() < Precision.SAFE_MIN) {
            return Vector3D.ZERO;
        }
        Vector3D fluxSat = rotation.applyTo(flux);
        Vector3D normal = this.getNormal(date, frame, position, rotation);
        double dot = Vector3D.dotProduct((Vector3D)normal, (Vector3D)fluxSat);
        if (dot > 0.0) {
            dot = -dot;
            normal = normal.negate();
        }
        Vector3D force = this.facetRadiationAcceleration(normal, this.solarArrayArea, fluxSat, dot);
        for (Facet bodyFacet : this.facets) {
            normal = bodyFacet.getNormal();
            dot = Vector3D.dotProduct((Vector3D)normal, (Vector3D)fluxSat);
            if (!(dot < 0.0)) continue;
            force = force.add((Vector)this.facetRadiationAcceleration(normal, bodyFacet.getArea(), fluxSat, dot));
        }
        return rotation.applyInverseTo(new Vector3D(1.0 / mass, force));
    }

    @Override
    public FieldVector3D<DerivativeStructure> radiationPressureAcceleration(AbsoluteDate date, Frame frame, FieldVector3D<DerivativeStructure> position, FieldRotation<DerivativeStructure> rotation, DerivativeStructure mass, FieldVector3D<DerivativeStructure> flux) throws OrekitException {
        if (((DerivativeStructure)flux.getNormSq()).getValue() < Precision.SAFE_MIN) {
            return new FieldVector3D(0.0, flux);
        }
        FieldVector3D fluxSat = rotation.applyTo(flux);
        FieldVector3D normal = this.getNormal(date, frame, position, rotation);
        DerivativeStructure dot = (DerivativeStructure)FieldVector3D.dotProduct(normal, (FieldVector3D)fluxSat);
        if (dot.getValue() > 0.0) {
            dot = dot.negate();
            normal = normal.negate();
        }
        FieldVector3D force = this.facetRadiationAcceleration((FieldVector3D<DerivativeStructure>)normal, this.solarArrayArea, (FieldVector3D<DerivativeStructure>)fluxSat, dot);
        for (Facet bodyFacet : this.facets) {
            normal = new FieldVector3D((RealFieldElement)mass.getField().getOne(), bodyFacet.getNormal());
            dot = (DerivativeStructure)FieldVector3D.dotProduct((FieldVector3D)normal, (FieldVector3D)fluxSat);
            if (!(dot.getValue() < 0.0)) continue;
            force = force.add(this.facetRadiationAcceleration((FieldVector3D<DerivativeStructure>)normal, bodyFacet.getArea(), (FieldVector3D<DerivativeStructure>)fluxSat, dot));
        }
        return rotation.applyInverseTo(new FieldVector3D((RealFieldElement)mass.reciprocal(), force));
    }

    @Override
    public FieldVector3D<DerivativeStructure> radiationPressureAcceleration(AbsoluteDate date, Frame frame, Vector3D position, Rotation rotation, double mass, Vector3D flux, String paramName) throws OrekitException {
        DerivativeStructure specularReflectionCoeffDS;
        DerivativeStructure absorptionCoeffDS;
        if (flux.getNormSq() < Precision.SAFE_MIN) {
            DerivativeStructure zero = new DerivativeStructure(1, 1, 0.0);
            return new FieldVector3D((RealFieldElement)zero, (RealFieldElement)zero, (RealFieldElement)zero);
        }
        if ("absorption coefficient".equals(paramName)) {
            absorptionCoeffDS = new DerivativeStructure(1, 1, 0, this.absorptionCoeff);
            specularReflectionCoeffDS = new DerivativeStructure(1, 1, this.specularReflectionCoeff);
        } else if ("reflection coefficient".equals(paramName)) {
            absorptionCoeffDS = new DerivativeStructure(1, 1, this.absorptionCoeff);
            specularReflectionCoeffDS = new DerivativeStructure(1, 1, 0, this.specularReflectionCoeff);
        } else {
            throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_PARAMETER_NAME, paramName, "absorption coefficient, reflection coefficient");
        }
        DerivativeStructure diffuseReflectionCoeffDS = absorptionCoeffDS.add(specularReflectionCoeffDS).subtract(1.0).negate();
        Vector3D fluxSat = rotation.applyTo(flux);
        Vector3D normal = this.getNormal(date, frame, position, rotation);
        double dot = Vector3D.dotProduct((Vector3D)normal, (Vector3D)fluxSat);
        if (dot > 0.0) {
            dot = -dot;
            normal = normal.negate();
        }
        FieldVector3D force = this.facetRadiationAcceleration(normal, this.solarArrayArea, fluxSat, dot, specularReflectionCoeffDS, diffuseReflectionCoeffDS);
        for (Facet bodyFacet : this.facets) {
            normal = bodyFacet.getNormal();
            dot = Vector3D.dotProduct((Vector3D)normal, (Vector3D)fluxSat);
            if (!(dot < 0.0)) continue;
            force = force.add(this.facetRadiationAcceleration(normal, bodyFacet.getArea(), fluxSat, dot, specularReflectionCoeffDS, diffuseReflectionCoeffDS));
        }
        return FieldRotation.applyInverseTo((Rotation)rotation, (FieldVector3D)new FieldVector3D(1.0 / mass, force));
    }

    private Vector3D facetRadiationAcceleration(Vector3D normal, double area, Vector3D fluxSat, double dot) {
        double psr = fluxSat.getNorm();
        double cN = 2.0 * area * dot * (this.diffuseReflectionCoeff / 3.0 - this.specularReflectionCoeff * dot / psr);
        double cS = area * dot / psr * (this.specularReflectionCoeff - 1.0);
        return new Vector3D(cN, normal, cS, fluxSat);
    }

    private FieldVector3D<DerivativeStructure> facetRadiationAcceleration(FieldVector3D<DerivativeStructure> normal, double area, FieldVector3D<DerivativeStructure> fluxSat, DerivativeStructure dot) {
        DerivativeStructure psr = (DerivativeStructure)fluxSat.getNorm();
        DerivativeStructure cN = dot.multiply(-2.0 * area).multiply(dot.divide(psr).multiply(this.specularReflectionCoeff).subtract(this.diffuseReflectionCoeff / 3.0));
        DerivativeStructure cS = dot.divide(psr).multiply(area * (this.specularReflectionCoeff - 1.0));
        return new FieldVector3D((RealFieldElement)cN, normal, (RealFieldElement)cS, fluxSat);
    }

    private FieldVector3D<DerivativeStructure> facetRadiationAcceleration(Vector3D normal, double area, Vector3D fluxSat, double dot, DerivativeStructure specularReflectionCoeffDS, DerivativeStructure diffuseReflectionCoeffDS) {
        double psr = fluxSat.getNorm();
        DerivativeStructure cN = diffuseReflectionCoeffDS.divide(3.0).subtract(specularReflectionCoeffDS.multiply(dot / psr)).multiply(2.0 * area * dot);
        DerivativeStructure cS = specularReflectionCoeffDS.subtract(1.0).multiply(area * dot / psr);
        return new FieldVector3D((RealFieldElement)cN, normal, (RealFieldElement)cS, fluxSat);
    }

    private static Facet[] simpleBoxFacets(double xLength, double yLength, double zLength) {
        return new Facet[]{new Facet(Vector3D.MINUS_I, yLength * zLength), new Facet(Vector3D.PLUS_I, yLength * zLength), new Facet(Vector3D.MINUS_J, xLength * zLength), new Facet(Vector3D.PLUS_J, xLength * zLength), new Facet(Vector3D.MINUS_K, xLength * yLength), new Facet(Vector3D.PLUS_K, xLength * yLength)};
    }

    private static List<Facet> filter(Facet[] facets) {
        ArrayList<Facet> filtered = new ArrayList<Facet>(facets.length);
        for (Facet facet : facets) {
            if (!(facet.getArea() > 0.0)) continue;
            filtered.add(facet);
        }
        return filtered;
    }

    @Override
    public void setAbsorptionCoefficient(double value) {
        this.absorptionCoeff = value;
        this.diffuseReflectionCoeff = 1.0 - (this.absorptionCoeff + this.specularReflectionCoeff);
    }

    @Override
    public double getAbsorptionCoefficient() {
        return this.absorptionCoeff;
    }

    @Override
    public void setReflectionCoefficient(double value) {
        this.specularReflectionCoeff = value;
        this.diffuseReflectionCoeff = 1.0 - (this.absorptionCoeff + this.specularReflectionCoeff);
    }

    @Override
    public double getReflectionCoefficient() {
        return this.specularReflectionCoeff;
    }

    @Override
    public void setDragCoefficient(double value) {
        this.dragCoeff = value;
    }

    @Override
    public double getDragCoefficient() {
        return this.dragCoeff;
    }

    public static class Facet {
        private final Vector3D normal;
        private final double area;

        public Facet(Vector3D normal, double area) {
            this.normal = normal.normalize();
            this.area = area;
        }

        public Vector3D getNormal() {
            return this.normal;
        }

        public double getArea() {
            return this.area;
        }
    }
}

