/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.sp3;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.Scanner;
import org.apache.commons.math3.exception.util.DummyLocalizable;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.general.OrbitFile;
import org.orekit.files.general.OrbitFileParser;
import org.orekit.files.general.SatelliteInformation;
import org.orekit.files.general.SatelliteTimeCoordinate;
import org.orekit.files.sp3.SP3File;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;
import org.orekit.utils.PVCoordinates;

public class SP3Parser
implements OrbitFileParser {
    @Override
    public SP3File parse(String fileName) throws OrekitException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(fileName);
            SP3File sP3File = this.parse(stream);
            return sP3File;
        }
        catch (FileNotFoundException e) {
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_FIND_FILE, fileName);
        }
        finally {
            try {
                if (stream != null) {
                    ((InputStream)stream).close();
                }
            }
            catch (IOException e) {}
        }
    }

    @Override
    public SP3File parse(InputStream stream) throws OrekitException {
        try {
            return this.parseInternal(stream);
        }
        catch (IOException e) {
            throw new OrekitException(e, (Localizable)new DummyLocalizable(e.getMessage()), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SP3File parseInternal(InputStream stream) throws OrekitException, IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        ParseInfo pi = new ParseInfo();
        String line = null;
        int lineNumber = 1;
        try {
            while (lineNumber < 23) {
                line = reader.readLine();
                if (line == null) {
                    throw new OrekitException((Localizable)OrekitMessages.SP3_UNEXPECTED_END_OF_FILE, lineNumber - 1);
                }
                this.parseHeaderLine(lineNumber++, line, pi);
            }
            boolean done = false;
            do {
                if ((line = reader.readLine()) == null) continue;
                if ("EOF".equalsIgnoreCase(line)) {
                    done = true;
                    continue;
                }
                if (line.length() <= 0) continue;
                this.parseContentLine(line, pi);
            } while (!done);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e1) {}
        }
        return pi.file;
    }

    private void parseHeaderLine(int lineNumber, String line, ParseInfo pi) throws OrekitException {
        SP3File file = pi.file;
        Scanner scanner = new Scanner(line).useDelimiter("\\s+").useLocale(Locale.US);
        block0 : switch (lineNumber) {
            case 1: {
                scanner.skip("#");
                String v = scanner.next();
                char version = v.substring(0, 1).toLowerCase().charAt(0);
                if (version != 'a' && version != 'b' && version != 'c') {
                    throw new OrekitException((Localizable)OrekitMessages.SP3_UNSUPPORTED_VERSION, Character.valueOf(version));
                }
                pi.hasVelocityEntries = "V".equals(v.substring(1, 2));
                int year = Integer.parseInt(v.substring(2));
                int month = scanner.nextInt();
                int day = scanner.nextInt();
                int hour = scanner.nextInt();
                int minute = scanner.nextInt();
                double second = scanner.nextDouble();
                AbsoluteDate epoch = new AbsoluteDate(year, month, day, hour, minute, second, (TimeScale)TimeScalesFactory.getGPS());
                file.setEpoch(epoch);
                int numEpochs = scanner.nextInt();
                file.setNumberOfEpochs(numEpochs);
                file.setDataUsed(scanner.next());
                file.setCoordinateSystem(scanner.next());
                file.setOrbitType(SP3File.SP3OrbitType.valueOf(scanner.next()));
                file.setAgency(scanner.next());
                break;
            }
            case 2: {
                scanner.skip("##");
                file.setGpsWeek(scanner.nextInt());
                file.setSecondsOfWeek(scanner.nextDouble());
                file.setEpochInterval(scanner.nextDouble());
                file.setJulianDay(scanner.nextInt());
                file.setDayFraction(scanner.nextDouble());
                break;
            }
            case 3: {
                pi.maxSatellites = Integer.parseInt(line.substring(4, 6).trim());
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                int lineLength = line.length();
                int count = file.getSatelliteCount();
                int startIdx = 9;
                while (count++ < pi.maxSatellites && startIdx + 3 <= lineLength) {
                    String satId = line.substring(startIdx, startIdx + 3).trim();
                    file.addSatellite(satId);
                    startIdx += 3;
                }
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                int lineLength = line.length();
                int satIdx = (lineNumber - 8) * 17;
                int startIdx = 9;
                while (satIdx < pi.maxSatellites && startIdx + 3 <= lineLength) {
                    SatelliteInformation satInfo = file.getSatellite(satIdx++);
                    int exponent = Integer.parseInt(line.substring(startIdx, startIdx + 3).trim());
                    satInfo.setAccuracy((int)Math.pow(2.0, exponent));
                    startIdx += 3;
                }
                break;
            }
            case 13: {
                file.setType(this.getFileType(line.substring(3, 5).trim()));
                String tsStr = line.substring(9, 12).trim();
                OrbitFile.TimeSystem ts = OrbitFile.TimeSystem.GPS;
                if (!tsStr.equalsIgnoreCase("ccc")) {
                    OrbitFile.TimeSystem.valueOf(tsStr);
                }
                file.setTimeSystem(ts);
                switch (ts) {
                    case GPS: {
                        pi.timeScale = TimeScalesFactory.getGPS();
                        break block0;
                    }
                    case GAL: {
                        pi.timeScale = TimeScalesFactory.getGST();
                        break block0;
                    }
                    case GLO: 
                    case QZS: {
                        throw new OrekitException((Localizable)OrekitMessages.SP3_UNSUPPORTED_TIMESYSTEM, ts.name());
                    }
                    case TAI: {
                        pi.timeScale = TimeScalesFactory.getTAI();
                        break block0;
                    }
                    case UTC: {
                        pi.timeScale = TimeScalesFactory.getUTC();
                        break block0;
                    }
                }
                pi.timeScale = TimeScalesFactory.getGPS();
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
        }
        if (scanner != null) {
            scanner.close();
        }
    }

    private void parseContentLine(String line, ParseInfo pi) {
        SP3File file = pi.file;
        switch (line.charAt(0)) {
            case '*': {
                int year = Integer.parseInt(line.substring(3, 7).trim());
                int month = Integer.parseInt(line.substring(8, 10).trim());
                int day = Integer.parseInt(line.substring(11, 13).trim());
                int hour = Integer.parseInt(line.substring(14, 16).trim());
                int minute = Integer.parseInt(line.substring(17, 19).trim());
                double second = Double.parseDouble(line.substring(20, 31).trim());
                pi.latestEpoch = new AbsoluteDate(year, month, day, hour, minute, second, pi.timeScale);
                break;
            }
            case 'P': {
                String satelliteId = line.substring(1, 4).trim();
                if (!file.containsSatellite(satelliteId)) {
                    pi.latestPosition = null;
                    break;
                }
                double x = Double.parseDouble(line.substring(4, 18).trim());
                double y = Double.parseDouble(line.substring(18, 32).trim());
                double z = Double.parseDouble(line.substring(32, 46).trim());
                pi.latestPosition = new Vector3D(x * 1000.0, y * 1000.0, z * 1000.0);
                pi.latestClock = Double.parseDouble(line.substring(46, 60).trim());
                if (pi.hasVelocityEntries) break;
                SatelliteTimeCoordinate coord = new SatelliteTimeCoordinate(pi.latestEpoch, pi.latestPosition, pi.latestClock);
                file.addSatelliteCoordinate(satelliteId, coord);
                break;
            }
            case 'V': {
                String satelliteId = line.substring(1, 4).trim();
                if (!file.containsSatellite(satelliteId)) break;
                double xv = Double.parseDouble(line.substring(4, 18).trim());
                double yv = Double.parseDouble(line.substring(18, 32).trim());
                double zv = Double.parseDouble(line.substring(32, 46).trim());
                Vector3D velocity = new Vector3D(xv / 10.0, yv / 10.0, zv / 10.0);
                double clockRateChange = Double.parseDouble(line.substring(46, 60).trim());
                SatelliteTimeCoordinate coord = new SatelliteTimeCoordinate(pi.latestEpoch, new PVCoordinates(pi.latestPosition, velocity), pi.latestClock, clockRateChange);
                file.addSatelliteCoordinate(satelliteId, coord);
                break;
            }
        }
    }

    private SP3File.SP3FileType getFileType(String fileType) {
        SP3File.SP3FileType type = SP3File.SP3FileType.UNDEFINED;
        if ("G".equalsIgnoreCase(fileType)) {
            type = SP3File.SP3FileType.GPS;
        } else if ("M".equalsIgnoreCase(fileType)) {
            type = SP3File.SP3FileType.MIXED;
        } else if ("R".equalsIgnoreCase(fileType)) {
            type = SP3File.SP3FileType.GLONASS;
        } else if ("L".equalsIgnoreCase(fileType)) {
            type = SP3File.SP3FileType.LEO;
        } else if ("E".equalsIgnoreCase(fileType)) {
            type = SP3File.SP3FileType.GALILEO;
        } else if ("C".equalsIgnoreCase(fileType)) {
            type = SP3File.SP3FileType.COMPASS;
        } else if ("J".equalsIgnoreCase(fileType)) {
            type = SP3File.SP3FileType.QZSS;
        }
        return type;
    }

    private static class ParseInfo {
        private SP3File file = new SP3File();
        private AbsoluteDate latestEpoch = null;
        private Vector3D latestPosition = null;
        private double latestClock = 0.0;
        private boolean hasVelocityEntries = false;
        private TimeScale timeScale = TimeScalesFactory.getGPS();
        private int maxSatellites = 0;

        protected ParseInfo() {
        }
    }
}

