/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.sp3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.orekit.files.general.OrbitFile;
import org.orekit.files.general.SatelliteInformation;
import org.orekit.files.general.SatelliteTimeCoordinate;
import org.orekit.time.AbsoluteDate;

public class SP3File
implements OrbitFile,
Serializable {
    private static final long serialVersionUID = 3333652174843017654L;
    private SP3FileType type;
    private OrbitFile.TimeSystem timeSystem;
    private AbsoluteDate epoch;
    private int gpsWeek;
    private double secondsOfWeek;
    private int julianDay;
    private double dayFraction;
    private double epochInterval;
    private int numberOfEpochs;
    private String coordinateSystem;
    private String dataUsed;
    private SP3OrbitType orbitType;
    private String agency;
    private List<SatelliteInformation> satellites = new ArrayList<SatelliteInformation>();
    private Map<String, SatelliteInformation> satelliteInfo = new HashMap<String, SatelliteInformation>();
    private Map<String, List<SatelliteTimeCoordinate>> satelliteCoords = new HashMap<String, List<SatelliteTimeCoordinate>>();

    public SP3FileType getType() {
        return this.type;
    }

    public void setType(SP3FileType fileType) {
        this.type = fileType;
    }

    @Override
    public OrbitFile.TimeSystem getTimeSystem() {
        return this.timeSystem;
    }

    public void setTimeSystem(OrbitFile.TimeSystem system) {
        this.timeSystem = system;
    }

    public String getDataUsed() {
        return this.dataUsed;
    }

    public void setDataUsed(String data) {
        this.dataUsed = data;
    }

    @Override
    public AbsoluteDate getEpoch() {
        return this.epoch;
    }

    public void setEpoch(AbsoluteDate time) {
        this.epoch = time;
    }

    public int getGpsWeek() {
        return this.gpsWeek;
    }

    public void setGpsWeek(int week) {
        this.gpsWeek = week;
    }

    public double getSecondsOfWeek() {
        return this.secondsOfWeek;
    }

    public void setSecondsOfWeek(double seconds) {
        this.secondsOfWeek = seconds;
    }

    public int getJulianDay() {
        return this.julianDay;
    }

    public void setJulianDay(int day) {
        this.julianDay = day;
    }

    public double getDayFraction() {
        return this.dayFraction;
    }

    public void setDayFraction(double fraction) {
        this.dayFraction = fraction;
    }

    @Override
    public double getEpochInterval() {
        return this.epochInterval;
    }

    public void setEpochInterval(double interval) {
        this.epochInterval = interval;
    }

    @Override
    public int getNumberOfEpochs() {
        return this.numberOfEpochs;
    }

    public void setNumberOfEpochs(int epochCount) {
        this.numberOfEpochs = epochCount;
    }

    @Override
    public String getCoordinateSystem() {
        return this.coordinateSystem;
    }

    public void setCoordinateSystem(String system) {
        this.coordinateSystem = system;
    }

    public SP3OrbitType getOrbitType() {
        return this.orbitType;
    }

    public void setOrbitType(SP3OrbitType oType) {
        this.orbitType = oType;
    }

    public String getAgency() {
        return this.agency;
    }

    public void setAgency(String agencyStr) {
        this.agency = agencyStr;
    }

    public void addSatellite(String satId) {
        if (this.getSatellite(satId) == null) {
            SatelliteInformation info = new SatelliteInformation(satId);
            this.satellites.add(info);
            this.satelliteInfo.put(satId, info);
            this.satelliteCoords.put(satId, new LinkedList());
        }
    }

    @Override
    public Collection<SatelliteInformation> getSatellites() {
        return Collections.unmodifiableCollection(this.satellites);
    }

    @Override
    public int getSatelliteCount() {
        return this.satellites.size();
    }

    @Override
    public SatelliteInformation getSatellite(String satId) {
        if (satId == null) {
            return null;
        }
        return this.satelliteInfo.get(satId);
    }

    public SatelliteInformation getSatellite(int n) {
        return this.satellites.get(n);
    }

    @Override
    public boolean containsSatellite(String satId) {
        return this.satelliteCoords.containsKey(satId);
    }

    @Override
    public List<SatelliteTimeCoordinate> getSatelliteCoordinates(String satId) {
        return this.satelliteCoords.get(satId);
    }

    public void addSatelliteCoordinate(String satId, SatelliteTimeCoordinate coord) {
        List<SatelliteTimeCoordinate> coords = this.satelliteCoords.get(satId);
        if (coords != null) {
            coords.add(coord);
        }
    }

    public static enum SP3OrbitType {
        FIT,
        EXT,
        BCT,
        HLM;

    }

    public static enum SP3FileType {
        GPS,
        MIXED,
        GLONASS,
        LEO,
        GALILEO,
        COMPASS,
        QZSS,
        UNDEFINED;

    }
}

