/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.general;

import java.io.Serializable;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeStamped;
import org.orekit.utils.PVCoordinates;

public class SatelliteTimeCoordinate
implements TimeStamped,
Serializable {
    private static final long serialVersionUID = -2099947583052252633L;
    private AbsoluteDate epoch;
    private PVCoordinates coordinate;
    private double clockCorrection;
    private double clockRateChange;

    public SatelliteTimeCoordinate(AbsoluteDate time, PVCoordinates coord) {
        this(time, coord, 0.0, 0.0);
    }

    public SatelliteTimeCoordinate(AbsoluteDate time, Vector3D pos, double clock) {
        this(time, new PVCoordinates(pos, Vector3D.ZERO), clock, 0.0);
    }

    public SatelliteTimeCoordinate(AbsoluteDate time, PVCoordinates coord, double clockCorr, double rateChange) {
        this.epoch = time;
        this.coordinate = coord;
        this.clockCorrection = clockCorr;
        this.clockRateChange = rateChange;
    }

    public AbsoluteDate getEpoch() {
        return this.epoch;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.getEpoch();
    }

    public void setEpoch(AbsoluteDate epoch) {
        this.epoch = epoch;
    }

    public PVCoordinates getCoordinate() {
        return this.coordinate;
    }

    public void setCoordinate(PVCoordinates coordinate) {
        this.coordinate = coordinate;
    }

    public double getClockCorrection() {
        return this.clockCorrection;
    }

    public void setClockCorrection(double corr) {
        this.clockCorrection = corr;
    }

    public double getClockRateChange() {
        return this.clockRateChange;
    }

    public void setClockRateChange(double rateChange) {
        this.clockRateChange = rateChange;
    }
}

