/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.orekit.bodies.CelestialBody;
import org.orekit.files.ccsds.ODMFile;
import org.orekit.files.general.OrbitFile;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;

public class ODMMetaData {
    private final ODMFile odmFile;
    private OrbitFile.TimeSystem timeSystem;
    private String objectName;
    private String objectID;
    private int launchYear;
    private int launchNumber;
    private String launchPiece;
    private String centerName;
    private CelestialBody centerBody;
    private boolean hasCreatableBody;
    private Frame refFrame;
    private String frameEpochString;
    private AbsoluteDate frameEpoch;
    private List<String> comment;

    ODMMetaData(ODMFile odmFile) {
        this.odmFile = odmFile;
        this.comment = new ArrayList<String>();
    }

    public ODMFile getODMFile() {
        return this.odmFile;
    }

    public OrbitFile.TimeSystem getTimeSystem() {
        return this.timeSystem;
    }

    void setTimeSystem(OrbitFile.TimeSystem timeSystem) {
        this.timeSystem = timeSystem;
    }

    public String getObjectName() {
        return this.objectName;
    }

    void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getObjectID() {
        return this.objectID;
    }

    void setObjectID(String objectID) {
        this.objectID = objectID;
    }

    void setLaunchYear(int launchYear) {
        this.launchYear = launchYear;
    }

    public int getLaunchYear() {
        return this.launchYear;
    }

    void setLaunchNumber(int launchNumber) {
        this.launchNumber = launchNumber;
    }

    public int getLaunchNumber() {
        return this.launchNumber;
    }

    void setLaunchPiece(String launchPiece) {
        this.launchPiece = launchPiece;
    }

    public String getLaunchPiece() {
        return this.launchPiece;
    }

    public String getCenterName() {
        return this.centerName;
    }

    void setCenterName(String centerName) {
        this.centerName = centerName;
    }

    public CelestialBody getCenterBody() {
        return this.centerBody;
    }

    void setCenterBody(CelestialBody centerBody) {
        this.centerBody = centerBody;
    }

    public boolean getHasCreatableBody() {
        return this.hasCreatableBody;
    }

    void setHasCreatableBody(boolean hasCreatableBody) {
        this.hasCreatableBody = hasCreatableBody;
    }

    public Frame getFrame() {
        return this.refFrame;
    }

    void setRefFrame(Frame refFrame) {
        this.refFrame = refFrame;
    }

    public String getFrameEpochString() {
        return this.frameEpochString;
    }

    void setFrameEpochString(String frameEpochString) {
        this.frameEpochString = frameEpochString;
    }

    public AbsoluteDate getFrameEpoch() {
        return this.frameEpoch;
    }

    void setFrameEpoch(AbsoluteDate frameEpoch) {
        this.frameEpoch = frameEpoch;
    }

    void setFrameEpoch(double offset) {
        this.frameEpoch = this.odmFile.getMissionReferenceDate().shiftedBy(offset);
    }

    public List<String> getComment() {
        return Collections.unmodifiableList(this.comment);
    }

    void setComment(List<String> comment) {
        this.comment = new ArrayList<String>(comment);
    }
}

