/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import java.util.Arrays;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;
import org.orekit.data.BodiesElements;
import org.orekit.data.FieldBodiesElements;
import org.orekit.data.GeneralTerm;
import org.orekit.data.LuniSolarTerm;
import org.orekit.data.NoFarPlanetsTerm;
import org.orekit.data.PlanetaryTerm;
import org.orekit.data.TideTerm;
import org.orekit.errors.OrekitException;

abstract class SeriesTerm<T extends RealFieldElement<T>> {
    private double[][] sinCoeff = new double[0][0];
    private double[][] cosCoeff = new double[0][0];

    protected SeriesTerm() {
    }

    public int getDegree(int index) {
        return this.sinCoeff[index].length - 1;
    }

    public void add(int index, int degree, double sinID, double cosID) {
        this.sinCoeff = SeriesTerm.extendArray(index, degree, this.sinCoeff);
        this.cosCoeff = SeriesTerm.extendArray(index, degree, this.cosCoeff);
        if (degree >= 0) {
            double[] dArray = this.sinCoeff[index];
            int n = degree;
            dArray[n] = dArray[n] + sinID;
            double[] dArray2 = this.cosCoeff[index];
            int n2 = degree;
            dArray2[n2] = dArray2[n2] + cosID;
        }
    }

    public double getSinCoeff(int index, int degree) {
        return this.sinCoeff[index][degree];
    }

    public double getCosCoeff(int index, int degree) {
        return this.cosCoeff[index][degree];
    }

    public double[] value(BodiesElements elements) {
        double tc = elements.getTC();
        double a = this.argument(elements);
        double sin = FastMath.sin((double)a);
        double cos = FastMath.cos((double)a);
        double[] values = new double[this.sinCoeff.length];
        for (int i = 0; i < values.length; ++i) {
            double s = 0.0;
            double c = 0.0;
            for (int j = this.sinCoeff[i].length - 1; j >= 0; --j) {
                s = s * tc + this.sinCoeff[i][j];
                c = c * tc + this.cosCoeff[i][j];
            }
            values[i] = s * sin + c * cos;
        }
        return values;
    }

    protected abstract double argument(BodiesElements var1);

    public T[] value(FieldBodiesElements<T> elements) {
        Object tc = elements.getTC();
        T a = this.argument(elements);
        RealFieldElement sin = (RealFieldElement)a.sin();
        RealFieldElement cos = (RealFieldElement)a.cos();
        RealFieldElement[] values = (RealFieldElement[])MathArrays.buildArray((Field)tc.getField(), (int)this.sinCoeff.length);
        for (int i = 0; i < values.length; ++i) {
            RealFieldElement s = (RealFieldElement)tc.getField().getZero();
            RealFieldElement c = (RealFieldElement)tc.getField().getZero();
            for (int j = this.sinCoeff[i].length - 1; j >= 0; --j) {
                s = (RealFieldElement)((RealFieldElement)s.multiply(tc)).add(this.sinCoeff[i][j]);
                c = (RealFieldElement)((RealFieldElement)c.multiply(tc)).add(this.cosCoeff[i][j]);
            }
            values[i] = (RealFieldElement)((RealFieldElement)s.multiply((Object)sin)).add(c.multiply((Object)cos));
        }
        return values;
    }

    protected abstract T argument(FieldBodiesElements<T> var1);

    public static <S extends RealFieldElement<S>> SeriesTerm<S> buildTerm(int cGamma, int cL, int cLPrime, int cF, int cD, int cOmega, int cMe, int cVe, int cE, int cMa, int cJu, int cSa, int cUr, int cNe, int cPa) {
        if (cGamma == 0 && cL == 0 && cLPrime == 0 && cF == 0 && cD == 0 && cOmega == 0) {
            return new PlanetaryTerm(cMe, cVe, cE, cMa, cJu, cSa, cUr, cNe, cPa);
        }
        if (cGamma == 0 && cMe == 0 && cVe == 0 && cE == 0 && cMa == 0 && cJu == 0 && cSa == 0 && cUr == 0 && cNe == 0 && cPa == 0) {
            return new LuniSolarTerm(cL, cLPrime, cF, cD, cOmega);
        }
        if (cGamma != 0 && cMe == 0 && cVe == 0 && cE == 0 && cMa == 0 && cJu == 0 && cSa == 0 && cUr == 0 && cNe == 0 && cPa == 0) {
            return new TideTerm(cGamma, cL, cLPrime, cF, cD, cOmega);
        }
        if (cGamma == 0 && cLPrime == 0 && cUr == 0 && cNe == 0 && cPa == 0) {
            return new NoFarPlanetsTerm(cL, cF, cD, cOmega, cMe, cVe, cE, cMa, cJu, cSa);
        }
        if (cGamma == 0) {
            return new GeneralTerm(cL, cLPrime, cF, cD, cOmega, cMe, cVe, cE, cMa, cJu, cSa, cUr, cNe, cPa);
        }
        throw OrekitException.createInternalError(null);
    }

    private static double[][] extendArray(int index, int degree, double[][] array) {
        Object extended;
        if (array.length > index) {
            extended = array;
        } else {
            extended = new double[index + 1][];
            System.arraycopy(array, 0, extended, 0, array.length);
            Arrays.fill((Object[])extended, array.length, index + 1, new double[0]);
        }
        extended[index] = SeriesTerm.extendArray(degree, extended[index]);
        return extended;
    }

    private static double[] extendArray(int degree, double[] array) {
        if (array.length > degree) {
            return array;
        }
        double[] extended = new double[degree + 1];
        System.arraycopy(array, 0, extended, 0, array.length);
        return extended;
    }
}

