/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import java.io.Serializable;
import org.apache.commons.math3.RealFieldElement;

public class PolynomialNutation<T extends RealFieldElement<T>>
implements Serializable {
    private static final long serialVersionUID = 20131007L;
    private double[] coefficients;

    public PolynomialNutation(double ... coefficients) {
        this.coefficients = (double[])coefficients.clone();
    }

    public double value(double tc) {
        double p = 0.0;
        for (int i = this.coefficients.length - 1; i >= 0; --i) {
            p = p * tc + this.coefficients[i];
        }
        return p;
    }

    public T value(T tc) {
        RealFieldElement p = (RealFieldElement)tc.getField().getZero();
        for (int i = this.coefficients.length - 1; i >= 0; --i) {
            p = (RealFieldElement)((RealFieldElement)p.multiply(tc)).add(this.coefficients[i]);
        }
        return (T)p;
    }
}

