/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import org.apache.commons.math3.RealFieldElement;
import org.orekit.data.BodiesElements;
import org.orekit.data.FieldBodiesElements;
import org.orekit.data.SeriesTerm;

class NoFarPlanetsTerm<T extends RealFieldElement<T>>
extends SeriesTerm<T> {
    private final int cL;
    private final int cF;
    private final int cD;
    private final int cOmega;
    private final int cMe;
    private final int cVe;
    private final int cE;
    private final int cMa;
    private final int cJu;
    private final int cSa;

    public NoFarPlanetsTerm(int cL, int cF, int cD, int cOmega, int cMe, int cVe, int cE, int cMa, int cJu, int cSa) {
        this.cL = cL;
        this.cF = cF;
        this.cD = cD;
        this.cOmega = cOmega;
        this.cMe = cMe;
        this.cVe = cVe;
        this.cE = cE;
        this.cMa = cMa;
        this.cJu = cJu;
        this.cSa = cSa;
    }

    @Override
    protected double argument(BodiesElements elements) {
        return (double)this.cL * elements.getL() + (double)this.cF * elements.getF() + (double)this.cD * elements.getD() + (double)this.cOmega * elements.getOmega() + (double)this.cMe * elements.getLMe() + (double)this.cVe * elements.getLVe() + (double)this.cE * elements.getLE() + (double)this.cMa * elements.getLMa() + (double)this.cJu * elements.getLJu() + (double)this.cSa * elements.getLSa();
    }

    @Override
    protected T argument(FieldBodiesElements<T> elements) {
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)elements.getL().multiply(this.cL)).add(elements.getF().multiply(this.cF))).add(elements.getD().multiply(this.cD))).add(elements.getOmega().multiply(this.cOmega))).add(elements.getLMe().multiply(this.cMe))).add(elements.getLVe().multiply(this.cVe))).add(elements.getLE().multiply(this.cE))).add(elements.getLMa().multiply(this.cMa))).add(elements.getLJu().multiply(this.cJu))).add(elements.getLSa().multiply(this.cSa)));
    }
}

