/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.bodies;

import java.io.Serializable;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.FastMath;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeStamped;
import org.orekit.utils.PVCoordinates;

class PosVelChebyshev
implements TimeStamped,
Serializable {
    private static final long serialVersionUID = -2220448511466595393L;
    private final AbsoluteDate start;
    private final double duration;
    private final double[] xCoeffs;
    private final double[] yCoeffs;
    private final double[] zCoeffs;

    public PosVelChebyshev(AbsoluteDate start, double duration, double[] xCoeffs, double[] yCoeffs, double[] zCoeffs) {
        this.start = start;
        this.duration = duration;
        this.xCoeffs = xCoeffs;
        this.yCoeffs = yCoeffs;
        this.zCoeffs = zCoeffs;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.start;
    }

    public double getValidityDuration() {
        return this.duration;
    }

    public boolean isSuccessorOf(PosVelChebyshev predecessor) {
        double gap = this.start.durationFrom(predecessor.start) - predecessor.duration;
        return FastMath.abs((double)gap) < 0.001;
    }

    public boolean inRange(AbsoluteDate date) {
        double dt = date.durationFrom(this.start);
        return dt >= -0.001 && dt <= this.duration + 0.001;
    }

    public PVCoordinates getPositionVelocityAcceleration(AbsoluteDate date) {
        double t = (2.0 * date.durationFrom(this.start) - this.duration) / this.duration;
        double twoT = 2.0 * t;
        double pKm1 = 1.0;
        double pK = t;
        double xP = this.xCoeffs[0];
        double yP = this.yCoeffs[0];
        double zP = this.zCoeffs[0];
        double qKm1 = 0.0;
        double qK = 1.0;
        double xV = 0.0;
        double yV = 0.0;
        double zV = 0.0;
        double rKm1 = 0.0;
        double rK = 0.0;
        double xA = 0.0;
        double yA = 0.0;
        double zA = 0.0;
        for (int k = 1; k < this.xCoeffs.length; ++k) {
            xP += this.xCoeffs[k] * pK;
            yP += this.yCoeffs[k] * pK;
            zP += this.zCoeffs[k] * pK;
            xV += this.xCoeffs[k] * qK;
            yV += this.yCoeffs[k] * qK;
            zV += this.zCoeffs[k] * qK;
            xA += this.xCoeffs[k] * rK;
            yA += this.yCoeffs[k] * rK;
            zA += this.zCoeffs[k] * rK;
            double pKm2 = pKm1;
            pKm1 = pK;
            pK = twoT * pKm1 - pKm2;
            double qKm2 = qKm1;
            qKm1 = qK;
            qK = twoT * qKm1 + 2.0 * pKm1 - qKm2;
            double rKm2 = rKm1;
            rKm1 = rK;
            rK = twoT * rKm1 + 4.0 * qKm1 - rKm2;
        }
        double vScale = 2.0 / this.duration;
        double aScale = vScale * vScale;
        return new PVCoordinates(new Vector3D(xP, yP, zP), new Vector3D(xV * vScale, yV * vScale, zV * vScale), new Vector3D(xA * aScale, yA * aScale, zA * aScale));
    }
}

