/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.bodies;

import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.FastMath;
import org.orekit.bodies.IAUPole;
import org.orekit.bodies.JPLEphemeridesLoader;
import org.orekit.time.AbsoluteDate;

class IAUPoleFactory {
    private IAUPoleFactory() {
    }

    public static IAUPole getIAUPole(JPLEphemeridesLoader.EphemerisType body) {
        switch (body) {
            case SUN: {
                return new IAUPole(){
                    private static final long serialVersionUID = 5715331729495237139L;

                    @Override
                    public Vector3D getPole(AbsoluteDate date) {
                        return new Vector3D(FastMath.toRadians((double)286.13), FastMath.toRadians((double)63.87));
                    }

                    @Override
                    public double getPrimeMeridianAngle(AbsoluteDate date) {
                        return FastMath.toRadians((double)(84.176 + 14.1844 * IAUPoleFactory.d(date)));
                    }
                };
            }
            case MERCURY: {
                return new IAUPole(){
                    private static final long serialVersionUID = -5769710119654037007L;

                    @Override
                    public Vector3D getPole(AbsoluteDate date) {
                        double t = IAUPoleFactory.t(date);
                        return new Vector3D(FastMath.toRadians((double)(281.0097 - 0.0328 * t)), FastMath.toRadians((double)(61.4143 - 0.0049 * t)));
                    }

                    @Override
                    public double getPrimeMeridianAngle(AbsoluteDate date) {
                        double[] m = this.computeMi(date);
                        return FastMath.toRadians((double)(329.5469 + 6.1385025 * IAUPoleFactory.d(date) + 0.00993822 * FastMath.sin((double)m[0]) - 0.00104581 * FastMath.sin((double)m[1]) - 1.028E-4 * FastMath.sin((double)m[2]) - 2.364E-5 * FastMath.sin((double)m[3]) - 5.32E-6 * FastMath.sin((double)m[4])));
                    }

                    private double[] computeMi(AbsoluteDate date) {
                        double d = IAUPoleFactory.d(date);
                        return new double[]{FastMath.toRadians((double)(174.791096 + 4.092335 * d)), FastMath.toRadians((double)(349.582171 + 8.18467 * d)), FastMath.toRadians((double)(164.373257 + 12.277005 * d)), FastMath.toRadians((double)(339.164343 + 16.36934 * d)), FastMath.toRadians((double)(153.955429 + 20.461675 * d))};
                    }
                };
            }
            case VENUS: {
                return new IAUPole(){
                    private static final long serialVersionUID = 7030506277976648896L;

                    @Override
                    public Vector3D getPole(AbsoluteDate date) {
                        return new Vector3D(FastMath.toRadians((double)272.76), FastMath.toRadians((double)67.16));
                    }

                    @Override
                    public double getPrimeMeridianAngle(AbsoluteDate date) {
                        return FastMath.toRadians((double)(160.2 - 1.4813688 * IAUPoleFactory.d(date)));
                    }
                };
            }
            case EARTH: {
                return new IAUPole(){
                    private static final long serialVersionUID = 6912325697192667056L;

                    @Override
                    public Vector3D getPole(AbsoluteDate date) {
                        double t = IAUPoleFactory.t(date);
                        return new Vector3D(FastMath.toRadians((double)(0.0 - 0.641 * t)), FastMath.toRadians((double)(90.0 - 0.557 * t)));
                    }

                    @Override
                    public double getPrimeMeridianAngle(AbsoluteDate date) {
                        return FastMath.toRadians((double)(190.147 + 360.9856235 * IAUPoleFactory.d(date)));
                    }
                };
            }
            case MOON: {
                return new IAUPole(){
                    private static final long serialVersionUID = -1310155975084976571L;

                    @Override
                    public Vector3D getPole(AbsoluteDate date) {
                        double[] e = this.computeEi(date);
                        double t = IAUPoleFactory.t(date);
                        return new Vector3D(FastMath.toRadians((double)(269.9949 + 0.0031 * t - 3.8787 * FastMath.sin((double)e[0]) - 0.1204 * FastMath.sin((double)e[1]) + 0.07 * FastMath.sin((double)e[2]) - 0.0172 * FastMath.sin((double)e[3]) + 0.0072 * FastMath.sin((double)e[5]) - 0.0052 * FastMath.sin((double)e[9]) + 0.0043 * FastMath.sin((double)e[12]))), FastMath.toRadians((double)(66.5392 + 0.013 * t + 1.5419 * FastMath.cos((double)e[0]) + 0.0239 * FastMath.cos((double)e[1]) - 0.0278 * FastMath.cos((double)e[2]) + 0.0068 * FastMath.cos((double)e[3]) - 0.0029 * FastMath.cos((double)e[5]) + 9.0E-4 * FastMath.cos((double)e[6]) + 8.0E-4 * FastMath.cos((double)e[9]) - 9.0E-4 * FastMath.cos((double)e[12]))));
                    }

                    @Override
                    public double getPrimeMeridianAngle(AbsoluteDate date) {
                        double[] e = this.computeEi(date);
                        double d = IAUPoleFactory.d(date);
                        return FastMath.toRadians((double)(38.3213 + (13.17635815 - 1.4E-12 * d) * d + 3.561 * FastMath.sin((double)e[0]) + 0.1208 * FastMath.sin((double)e[1]) - 0.0642 * FastMath.sin((double)e[2]) + 0.0158 * FastMath.sin((double)e[3]) + 0.0252 * FastMath.sin((double)e[4]) - 0.0066 * FastMath.sin((double)e[5]) - 0.0047 * FastMath.sin((double)e[6]) - 0.0046 * FastMath.sin((double)e[7]) + 0.0028 * FastMath.sin((double)e[8]) + 0.0052 * FastMath.sin((double)e[9]) + 0.004 * FastMath.sin((double)e[10]) + 0.0019 * FastMath.sin((double)e[11]) - 0.0044 * FastMath.sin((double)e[12])));
                    }

                    private double[] computeEi(AbsoluteDate date) {
                        double d = IAUPoleFactory.d(date);
                        return new double[]{FastMath.toRadians((double)(125.045 - 0.0529921 * d)), FastMath.toRadians((double)(250.089 - 0.1059842 * d)), FastMath.toRadians((double)(260.008 + 13.0120009 * d)), FastMath.toRadians((double)(176.625 + 13.3407154 * d)), FastMath.toRadians((double)(357.529 + 0.9856003 * d)), FastMath.toRadians((double)(311.589 + 26.4057084 * d)), FastMath.toRadians((double)(134.963 + 13.064993 * d)), FastMath.toRadians((double)(276.617 + 0.3287146 * d)), FastMath.toRadians((double)(34.226 + 1.7484877 * d)), FastMath.toRadians((double)(15.134 - 0.1589763 * d)), FastMath.toRadians((double)(119.743 + 0.0036096 * d)), FastMath.toRadians((double)(239.961 + 0.1643573 * d)), FastMath.toRadians((double)(25.053 + 12.9590088 * d))};
                    }
                };
            }
            case MARS: {
                return new IAUPole(){
                    private static final long serialVersionUID = 1471983418540015411L;

                    @Override
                    public Vector3D getPole(AbsoluteDate date) {
                        double t = IAUPoleFactory.t(date);
                        return new Vector3D(FastMath.toRadians((double)(317.68143 - 0.1061 * t)), FastMath.toRadians((double)(52.8865 - 0.0609 * t)));
                    }

                    @Override
                    public double getPrimeMeridianAngle(AbsoluteDate date) {
                        return FastMath.toRadians((double)(176.63 + 350.89198226 * IAUPoleFactory.d(date)));
                    }
                };
            }
            case JUPITER: {
                return new IAUPole(){
                    private static final long serialVersionUID = 6959753758673537524L;

                    @Override
                    public Vector3D getPole(AbsoluteDate date) {
                        double t = IAUPoleFactory.t(date);
                        double ja = FastMath.toRadians((double)(99.360714 + 4850.4046 * t));
                        double jb = FastMath.toRadians((double)(175.895369 + 1191.9605 * t));
                        double jc = FastMath.toRadians((double)(300.323162 + 262.5475 * t));
                        double jd = FastMath.toRadians((double)(114.012305 + 6070.2476 * t));
                        double je = FastMath.toRadians((double)(49.511251 + 64.3 * t));
                        return new Vector3D(FastMath.toRadians((double)(268.056595 - 0.006499 * t + 1.17E-4 * FastMath.sin((double)ja) + 9.38E-4 * FastMath.sin((double)jb) + 0.001432 * FastMath.sin((double)jc) + 3.0E-5 * FastMath.sin((double)jd) + 0.00215 * FastMath.sin((double)je))), FastMath.toRadians((double)(64.495303 + 0.002413 * t)) + 5.0E-5 * FastMath.cos((double)ja) + 4.04E-4 * FastMath.cos((double)jb) + 6.17E-4 * FastMath.cos((double)jc) - 1.3E-5 * FastMath.cos((double)jd) + 9.26E-4 * FastMath.cos((double)je));
                    }

                    @Override
                    public double getPrimeMeridianAngle(AbsoluteDate date) {
                        return FastMath.toRadians((double)(284.95 + 870.536 * IAUPoleFactory.d(date)));
                    }
                };
            }
            case SATURN: {
                return new IAUPole(){
                    private static final long serialVersionUID = -1082211873912149774L;

                    @Override
                    public Vector3D getPole(AbsoluteDate date) {
                        double t = IAUPoleFactory.t(date);
                        return new Vector3D(FastMath.toRadians((double)(40.589 - 0.036 * t)), FastMath.toRadians((double)(83.537 - 0.004 * t)));
                    }

                    @Override
                    public double getPrimeMeridianAngle(AbsoluteDate date) {
                        return FastMath.toRadians((double)(38.9 + 810.7939024 * IAUPoleFactory.d(date)));
                    }
                };
            }
            case URANUS: {
                return new IAUPole(){
                    private static final long serialVersionUID = 362792230470085154L;

                    @Override
                    public Vector3D getPole(AbsoluteDate date) {
                        return new Vector3D(FastMath.toRadians((double)257.311), FastMath.toRadians((double)-15.175));
                    }

                    @Override
                    public double getPrimeMeridianAngle(AbsoluteDate date) {
                        return FastMath.toRadians((double)(203.81 - 501.1600928 * IAUPoleFactory.d(date)));
                    }
                };
            }
            case NEPTUNE: {
                return new IAUPole(){
                    private static final long serialVersionUID = 560614555734665287L;

                    @Override
                    public Vector3D getPole(AbsoluteDate date) {
                        double n = FastMath.toRadians((double)(357.85 + 52.316 * IAUPoleFactory.t(date)));
                        return new Vector3D(FastMath.toRadians((double)(299.36 + 0.7 * FastMath.sin((double)n))), FastMath.toRadians((double)(43.46 - 0.51 * FastMath.cos((double)n))));
                    }

                    @Override
                    public double getPrimeMeridianAngle(AbsoluteDate date) {
                        double n = FastMath.toRadians((double)(357.85 + 52.316 * IAUPoleFactory.t(date)));
                        return FastMath.toRadians((double)(253.18 + 536.3128492 * IAUPoleFactory.d(date) - 0.48 * FastMath.sin((double)n)));
                    }
                };
            }
            case PLUTO: {
                return new IAUPole(){
                    private static final long serialVersionUID = -1277113129327018062L;

                    @Override
                    public Vector3D getPole(AbsoluteDate date) {
                        return new Vector3D(FastMath.toRadians((double)132.993), FastMath.toRadians((double)-6.163));
                    }

                    @Override
                    public double getPrimeMeridianAngle(AbsoluteDate date) {
                        return FastMath.toRadians((double)(302.695 + 56.3625225 * IAUPoleFactory.d(date)));
                    }
                };
            }
        }
        return new GCRFAligned();
    }

    private static double t(AbsoluteDate date) {
        return date.durationFrom(AbsoluteDate.J2000_EPOCH) / 3.15576E9;
    }

    private static double d(AbsoluteDate date) {
        return date.durationFrom(AbsoluteDate.J2000_EPOCH) / 86400.0;
    }

    private static class GCRFAligned
    implements IAUPole {
        private static final long serialVersionUID = 20130327L;

        private GCRFAligned() {
        }

        @Override
        public Vector3D getPole(AbsoluteDate date) {
            return Vector3D.PLUS_K;
        }

        @Override
        public double getPrimeMeridianAngle(AbsoluteDate date) {
            return 0.0;
        }
    }
}

