/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.AttitudeProviderModifier;
import org.orekit.attitudes.GroundPointing;
import org.orekit.errors.OrekitException;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class YawCompensation
extends GroundPointing
implements AttitudeProviderModifier {
    private static final long serialVersionUID = 20140811L;
    private static final PVCoordinates PLUS_J = new PVCoordinates(Vector3D.PLUS_J, Vector3D.ZERO, Vector3D.ZERO);
    private static final PVCoordinates PLUS_K = new PVCoordinates(Vector3D.PLUS_K, Vector3D.ZERO, Vector3D.ZERO);
    private final GroundPointing groundPointingLaw;

    public YawCompensation(GroundPointing groundPointingLaw) {
        super(groundPointingLaw.getBodyFrame());
        this.groundPointingLaw = groundPointingLaw;
    }

    @Override
    public AttitudeProvider getUnderlyingAttitudeProvider() {
        return this.groundPointingLaw;
    }

    @Override
    protected TimeStampedPVCoordinates getTargetPV(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) throws OrekitException {
        return this.groundPointingLaw.getTargetPV(pvProv, date, frame);
    }

    public Attitude getBaseState(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) throws OrekitException {
        return this.groundPointingLaw.getAttitude(pvProv, date, frame);
    }

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) throws OrekitException {
        Transform bodyToRef = this.getBodyFrame().getTransformTo(frame, date);
        TimeStampedPVCoordinates slidingRef = this.getTargetPV(pvProv, date, frame);
        PVCoordinates slidingBody = bodyToRef.getInverse().transformPVCoordinates((PVCoordinates)slidingRef);
        PVCoordinates relativePosition = new PVCoordinates(pvProv.getPVCoordinates(date, frame), (PVCoordinates)slidingRef);
        Vector3D v = bodyToRef.getRotation().applyTo(slidingBody.getVelocity());
        Vector3D a = new Vector3D(1.0, bodyToRef.getRotation().applyTo(slidingBody.getAcceleration()), -1.0, Vector3D.crossProduct((Vector3D)bodyToRef.getRotationRate(), (Vector3D)v));
        PVCoordinates relativeVelocity = new PVCoordinates(v, a, Vector3D.ZERO);
        PVCoordinates relativeNormal = PVCoordinates.crossProduct(relativePosition, relativeVelocity).normalize();
        return new Attitude(frame, new TimeStampedAngularCoordinates(date, relativePosition.normalize(), relativeNormal.normalize(), PLUS_K, PLUS_J, 1.0E-9));
    }

    public double getYawAngle(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) throws OrekitException {
        Rotation rBase = this.getBaseState(pvProv, date, frame).getRotation();
        Rotation rCompensated = this.getAttitude(pvProv, date, frame).getRotation();
        Rotation compensation = rCompensated.applyTo(rBase.revert());
        return -compensation.applyTo(Vector3D.PLUS_I).getAlpha();
    }
}

