/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import java.util.ArrayList;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.GroundPointing;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.errors.OrekitException;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedPVCoordinates;

public class NadirPointing
extends GroundPointing {
    private static final long serialVersionUID = 9077899256315179822L;
    private final BodyShape shape;

    public NadirPointing(BodyShape shape) {
        super(shape.getBodyFrame());
        this.shape = shape;
    }

    @Override
    protected TimeStampedPVCoordinates getTargetPV(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) throws OrekitException {
        Transform refToBody = frame.getTransformTo(this.shape.getBodyFrame(), date);
        double h = 0.01;
        ArrayList<TimeStampedPVCoordinates> sample = new ArrayList<TimeStampedPVCoordinates>();
        sample.add(this.nadirRef(pvProv.getPVCoordinates(date.shiftedBy(-0.02), frame), refToBody.shiftedBy(-0.02)));
        sample.add(this.nadirRef(pvProv.getPVCoordinates(date.shiftedBy(-0.01), frame), refToBody.shiftedBy(-0.01)));
        sample.add(this.nadirRef(pvProv.getPVCoordinates(date, frame), refToBody));
        sample.add(this.nadirRef(pvProv.getPVCoordinates(date.shiftedBy(0.01), frame), refToBody.shiftedBy(0.01)));
        sample.add(this.nadirRef(pvProv.getPVCoordinates(date.shiftedBy(0.02), frame), refToBody.shiftedBy(0.02)));
        return TimeStampedPVCoordinates.interpolate(date, CartesianDerivativesFilter.USE_P, sample);
    }

    private TimeStampedPVCoordinates nadirRef(TimeStampedPVCoordinates scRef, Transform refToBody) throws OrekitException {
        Vector3D satInBodyFrame = refToBody.transformPosition(scRef.getPosition());
        GeodeticPoint gpSat = this.shape.transform(satInBodyFrame, this.getBodyFrame(), scRef.getDate());
        GeodeticPoint gpNadir = new GeodeticPoint(gpSat.getLatitude(), gpSat.getLongitude(), 0.0);
        Vector3D pNadirBody = this.shape.transform(gpNadir);
        Vector3D pNadirRef = refToBody.getInverse().transformPosition(pNadirBody);
        return new TimeStampedPVCoordinates(scRef.getDate(), pNadirRef, Vector3D.ZERO, Vector3D.ZERO);
    }
}

