/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.FastMath;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public abstract class GroundPointing
implements AttitudeProvider {
    private static final long serialVersionUID = 20140811L;
    private static final PVCoordinates PLUS_J = new PVCoordinates(Vector3D.PLUS_J, Vector3D.ZERO, Vector3D.ZERO);
    private static final PVCoordinates PLUS_K = new PVCoordinates(Vector3D.PLUS_K, Vector3D.ZERO, Vector3D.ZERO);
    private final Frame bodyFrame;

    protected GroundPointing(Frame bodyFrame) {
        this.bodyFrame = bodyFrame;
    }

    public Frame getBodyFrame() {
        return this.bodyFrame;
    }

    protected abstract TimeStampedPVCoordinates getTargetPV(PVCoordinatesProvider var1, AbsoluteDate var2, Frame var3) throws OrekitException;

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) throws OrekitException {
        TimeStampedPVCoordinates pva = pvProv.getPVCoordinates(date, frame);
        TimeStampedPVCoordinates delta = new TimeStampedPVCoordinates(date, pva, (PVCoordinates)this.getTargetPV(pvProv, date, frame));
        if (delta.getPosition().getNorm() == 0.0) {
            throw new OrekitException((Localizable)OrekitMessages.SATELLITE_COLLIDED_WITH_TARGET, new Object[0]);
        }
        Vector3D p = pva.getPosition();
        Vector3D v = pva.getVelocity();
        Vector3D a = pva.getAcceleration();
        double r2 = p.getNormSq();
        double r = FastMath.sqrt((double)r2);
        Vector3D keplerianJerk = new Vector3D(-3.0 * Vector3D.dotProduct((Vector3D)p, (Vector3D)v) / r2, a, -a.getNorm() / r, v);
        PVCoordinates velocity = new PVCoordinates(v, a, keplerianJerk);
        PVCoordinates los = delta.normalize();
        PVCoordinates normal = PVCoordinates.crossProduct(delta, velocity).normalize();
        TimeStampedAngularCoordinates ac = new TimeStampedAngularCoordinates(date, los, normal, PLUS_K, PLUS_J, 1.0E-9);
        return new Attitude(date, frame, ac);
    }
}

