/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedPVCoordinates;

public class CelestialBodyPointed
implements AttitudeProvider {
    private static final long serialVersionUID = 6222161082155807729L;
    private final Frame celestialFrame;
    private final PVCoordinatesProvider pointedBody;
    private final Vector3D phasingCel;
    private final Vector3D pointingSat;
    private final Vector3D phasingSat;

    public CelestialBodyPointed(Frame celestialFrame, PVCoordinatesProvider pointedBody, Vector3D phasingCel, Vector3D pointingSat, Vector3D phasingSat) {
        this.celestialFrame = celestialFrame;
        this.pointedBody = pointedBody;
        this.phasingCel = phasingCel;
        this.pointingSat = pointingSat;
        this.phasingSat = phasingSat;
    }

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) throws OrekitException {
        TimeStampedPVCoordinates satPV = pvProv.getPVCoordinates(date, this.celestialFrame);
        TimeStampedPVCoordinates bodyPV = this.pointedBody.getPVCoordinates(date, this.celestialFrame);
        PVCoordinates pointing = new PVCoordinates(satPV, (PVCoordinates)bodyPV);
        Vector3D pointingP = pointing.getPosition();
        double r2 = Vector3D.dotProduct((Vector3D)pointingP, (Vector3D)pointingP);
        Vector3D rotAxisCel = new Vector3D(1.0 / r2, Vector3D.crossProduct((Vector3D)pointingP, (Vector3D)pointing.getVelocity()));
        Vector3D v1 = Vector3D.crossProduct((Vector3D)rotAxisCel, (Vector3D)this.phasingCel);
        Vector3D v2 = Vector3D.crossProduct((Vector3D)pointingP, (Vector3D)this.phasingCel);
        double compensation = -Vector3D.dotProduct((Vector3D)v1, (Vector3D)v2) / v2.getNormSq();
        Vector3D phasedRotAxisCel = new Vector3D(1.0, rotAxisCel, compensation, pointingP);
        Rotation celToSatRotation = new Rotation(pointingP, this.phasingCel, this.pointingSat, this.phasingSat);
        Transform transform = new Transform(date, celToSatRotation, celToSatRotation.applyTo(phasedRotAxisCel));
        if (frame != this.celestialFrame) {
            transform = new Transform(date, frame.getTransformTo(this.celestialFrame, date), transform);
        }
        return new Attitude(date, frame, transform.getRotation(), transform.getRotationRate(), transform.getRotationAcceleration());
    }
}

