/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.orekit.errors.OrekitException;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeInterpolable;
import org.orekit.time.TimeShiftable;
import org.orekit.time.TimeStamped;
import org.orekit.utils.AngularCoordinates;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.TimeStampedAngularCoordinates;

public class Attitude
implements TimeStamped,
TimeShiftable<Attitude>,
TimeInterpolable<Attitude>,
Serializable {
    private static final long serialVersionUID = 20140611L;
    private final Frame referenceFrame;
    private final TimeStampedAngularCoordinates orientation;

    public Attitude(Frame referenceFrame, TimeStampedAngularCoordinates orientation) {
        this.referenceFrame = referenceFrame;
        this.orientation = orientation;
    }

    public Attitude(AbsoluteDate date, Frame referenceFrame, AngularCoordinates orientation) {
        this(referenceFrame, new TimeStampedAngularCoordinates(date, orientation.getRotation(), orientation.getRotationRate(), orientation.getRotationAcceleration()));
    }

    public Attitude(AbsoluteDate date, Frame referenceFrame, Rotation attitude, Vector3D spin, Vector3D acceleration) {
        this(referenceFrame, new TimeStampedAngularCoordinates(date, attitude, spin, acceleration));
    }

    @Override
    public Attitude shiftedBy(double dt) {
        return new Attitude(this.referenceFrame, this.orientation.shiftedBy(dt));
    }

    public Attitude withReferenceFrame(Frame newReferenceFrame) throws OrekitException {
        if (newReferenceFrame == this.referenceFrame) {
            return this;
        }
        Transform t = newReferenceFrame.getTransformTo(this.referenceFrame, this.orientation.getDate());
        return new Attitude(this.orientation.getDate(), newReferenceFrame, this.orientation.getRotation().applyTo(t.getRotation()), this.orientation.getRotationRate().add((Vector)this.orientation.getRotation().applyTo(t.getRotationRate())), this.orientation.getRotationAcceleration().add((Vector)this.orientation.getRotation().applyTo(t.getRotationAcceleration())));
    }

    @Override
    public AbsoluteDate getDate() {
        return this.orientation.getDate();
    }

    public Frame getReferenceFrame() {
        return this.referenceFrame;
    }

    public TimeStampedAngularCoordinates getOrientation() {
        return this.orientation;
    }

    public Rotation getRotation() {
        return this.orientation.getRotation();
    }

    public Vector3D getSpin() {
        return this.orientation.getRotationRate();
    }

    public Vector3D getRotationAcceleration() {
        return this.orientation.getRotationAcceleration();
    }

    @Override
    public Attitude interpolate(AbsoluteDate interpolationDate, Collection<Attitude> sample) throws OrekitException {
        ArrayList<TimeStampedAngularCoordinates> datedPV = new ArrayList<TimeStampedAngularCoordinates>(sample.size());
        for (Attitude attitude : sample) {
            datedPV.add(attitude.orientation);
        }
        TimeStampedAngularCoordinates interpolated = TimeStampedAngularCoordinates.interpolate(interpolationDate, AngularDerivativesFilter.USE_RR, datedPV);
        return new Attitude(this.referenceFrame, interpolated);
    }
}

