/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.topology.ui.renderers;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.apogy.common.emf.FeaturePathAdapter;
import org.eclipse.apogy.common.emf.impl.FeaturePathAdapterCustomImpl;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyPackage;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.dialogs.NodeSelectionDialog;
import org.eclipse.apogy.core.topology.ApogyCoreTopologyFacade;
import org.eclipse.core.databinding.Binding;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.SimpleControlSWTControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NodeSWTRenderer
extends SimpleControlSWTControlSWTRenderer {
    private Text txtNodeId;
    private Button btnSelect;
    private FeaturePathAdapter adapter;

    @Inject
    public NodeSWTRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, EMFFormsEditSupport emfFormsEditSupport) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
    }

    protected Control createSWTControl(final Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).create());
        main.setLayoutData((Object)new GridData(4, 1, true, false, 1, 1));
        main.setBackground(parent.getBackground());
        main.setBackgroundMode(2);
        this.txtNodeId = new Text(main, 2048);
        this.txtNodeId.setEditable(false);
        Object obj = this.getValue();
        if (obj instanceof Node) {
            Node node = (Node)obj;
            if (node.getNodeId() != null) {
                this.txtNodeId.setText(node.getNodeId());
            } else {
                this.txtNodeId.setText("");
            }
        } else {
            this.txtNodeId.setText("");
        }
        GridData gd_txtNodeId = new GridData(4, 0x1000000, true, false);
        gd_txtNodeId.minimumWidth = 100;
        gd_txtNodeId.widthHint = 100;
        this.txtNodeId.setLayoutData((Object)gd_txtNodeId);
        this.btnSelect = new Button(main, 0);
        this.btnSelect.setText("Select...");
        this.btnSelect.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.btnSelect.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NodeSelectionDialog nodeSelectionDialog = new NodeSelectionDialog(parent.getShell(), NodeSWTRenderer.this.getRootNode());
                if (nodeSelectionDialog.open() == 0) {
                    Node node = nodeSelectionDialog.getSelectedNode();
                    try {
                        NodeSWTRenderer.this.getModelValue().setValue((Object)node);
                    }
                    catch (DatabindingFailedException e1) {
                        e1.printStackTrace();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnSelect.setEnabled(true);
        return main;
    }

    protected Binding[] createBindings(Control control) throws DatabindingFailedException {
        this.getAdapter().init(this.getViewModelContext().getDomainModel());
        return new Binding[0];
    }

    private Node getRootNode() {
        if (ApogyCoreTopologyFacade.INSTANCE.getApogyTopology() != null) {
            return ApogyCoreTopologyFacade.INSTANCE.getApogyTopology().getRootNode();
        }
        return null;
    }

    public FeaturePathAdapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new FeaturePathAdapterCustomImpl(){

                public List<? extends EStructuralFeature> getFeatureList() {
                    ArrayList<Object> features = new ArrayList<Object>();
                    features.add(NodeSWTRenderer.this.getEStructuralFeature());
                    features.add(ApogyCommonTopologyPackage.Literals.NODE__NODE_ID);
                    return features;
                }

                public void notifyChanged(Notification msg) {
                    Object obj = NodeSWTRenderer.this.getValue();
                    if (obj instanceof Node) {
                        String text = ((Node)obj).getNodeId();
                        if (text == null) {
                            text = "";
                        }
                        NodeSWTRenderer.this.txtNodeId.setText(text);
                    } else {
                        NodeSWTRenderer.this.txtNodeId.setText("");
                    }
                }
            };
        }
        return this.adapter;
    }

    private EStructuralFeature getEStructuralFeature() {
        try {
            return (EStructuralFeature)this.getModelValue().getValueType();
        }
        catch (DatabindingFailedException databindingFailedException) {
            return null;
        }
    }

    private Object getValue() {
        try {
            return this.getModelValue().getValue();
        }
        catch (DatabindingFailedException databindingFailedException) {
            return null;
        }
    }

    protected void dispose() {
        this.getAdapter().dispose();
        super.dispose();
    }

    protected String getUnsetText() {
        return "unset value";
    }
}

