/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.topology.ui.parts;

import javax.inject.Inject;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.composites.TopologyTreeComposite;
import org.eclipse.apogy.core.ApogyTopology;
import org.eclipse.apogy.core.topology.ui.parts.AbstractApogyTopologyBasedPart;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ApogyTopologyEditorPart
extends AbstractApogyTopologyBasedPart {
    private TopologyTreeComposite topologyTreeComposite;
    @Inject
    ESelectionService selectionService;

    protected void createComposite(Composite parent, int style) {
        ECollectionCompositeSettings settings = ApogyCommonEMFUIFactory.eINSTANCE.createECollectionCompositeSettings();
        settings.setCollectionSectionTitle("Topology");
        settings.setDetailSectionTitle("Details");
        this.topologyTreeComposite = new TopologyTreeComposite(parent, style, null, null, settings){

            protected void selectionChanged(IStructuredSelection selection) {
                if (!selection.isEmpty() && selection.getFirstElement() instanceof Node) {
                    Node node = (Node)selection.getFirstElement();
                    ApogyTopologyEditorPart.this.selectionService.setSelection((Object)node);
                }
            }

            protected void createButtons(Composite parent, int style) {
                this.createNewButton(parent, style);
                this.createDeleteButton(parent, style);
                this.createRefreshButton(parent, style);
            }

            protected Button createRefreshButton(Composite parent, int style) {
                Button btnRefresh = 1.createButton((Composite)parent, (int)0, (String)"Refresh", (Listener)new Listener(){

                    public void handleEvent(Event event) {
                        try {
                            BusyIndicator.showWhile((Display)this.getDisplay(), () -> this.refreshViewer());
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        this.refreshViewer();
                    }
                });
                this.createRefreshButtonBindings(btnRefresh);
                return btnRefresh;
            }

            protected void createRefreshButtonBindings(Button button) {
            }
        };
    }

    @Override
    protected void newTopology(ApogyTopology apogyTopology) {
        if (this.topologyTreeComposite != null && !this.topologyTreeComposite.isDisposed()) {
            if (apogyTopology != null) {
                this.topologyTreeComposite.setRootEObject((EObject)apogyTopology.getRootNode());
            } else {
                this.topologyTreeComposite.setRootEObject(null);
            }
        }
    }
}

