/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.topology.ui.composites;

import org.eclipse.apogy.core.ApogyCoreFacade;
import org.eclipse.apogy.core.ApogySystem;
import org.eclipse.apogy.core.ui.wizards.NewApogySystemWizard;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogySystemFileSelectionComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(ApogySystemFileSelectionComposite.class);
    protected ApogySystem apogySystem;
    protected String apogySystemFilePath;
    protected Label lblApogySystemFilePath;
    protected Button btnOpen;
    protected Button btnNew;
    protected Button btnSave;
    private EContentAdapter systemAdapter;

    public ApogySystemFileSelectionComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(5, false));
        Label fileLabel = new Label((Composite)this, 0);
        fileLabel.setText("Apogy System File :");
        this.lblApogySystemFilePath = new Label((Composite)this, 2048);
        this.lblApogySystemFilePath.setText("");
        this.lblApogySystemFilePath.setToolTipText("");
        GridData gd_lblApogySystemFilePath = new GridData(4, 0x1000000, true, false);
        this.lblApogySystemFilePath.setLayoutData((Object)gd_lblApogySystemFilePath);
        this.btnOpen = new Button((Composite)this, 8);
        this.btnOpen.setText("Open");
        this.btnOpen.setToolTipText("Opens an existing Apogy System file.");
        GridData gd_btnOpen = new GridData(0x1000000, 128, false, false);
        this.btnOpen.setLayoutData((Object)gd_btnOpen);
        this.btnOpen.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                FileDialog fd = new FileDialog(ApogySystemFileSelectionComposite.this.getShell(), 4096);
                fd.setText("Select an ApogySystem File");
                String[] filterExt = new String[]{"*.ss"};
                fd.setFilterExtensions(filterExt);
                String filePath = fd.open();
                if (filePath != null) {
                    try {
                        ApogySystemFileSelectionComposite.this.setApogySystem(ApogyCoreFacade.INSTANCE.loadApogySystemFromFile(filePath));
                        ApogySystemFileSelectionComposite.this.setApogySystemFilePath(filePath);
                    }
                    catch (Exception e) {
                        ApogySystemFileSelectionComposite.this.setApogySystem(null);
                        ApogySystemFileSelectionComposite.this.setApogySystemFilePath(null);
                        Logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.btnNew = new Button((Composite)this, 8);
        this.btnNew.setText("New");
        this.btnNew.setToolTipText("Creates a new Apogy System file.");
        GridData gd_btnNew = new GridData(0x1000000, 128, false, false);
        this.btnNew.setLayoutData((Object)gd_btnNew);
        this.btnNew.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                NewApogySystemWizard newApogySystemWizard = new NewApogySystemWizard();
                int result = new WizardDialog(ApogySystemFileSelectionComposite.this.getShell(), (IWizard)newApogySystemWizard).open();
                if (result == 0 && newApogySystemWizard.getApogySystem() != null) {
                    ApogySystemFileSelectionComposite.this.setApogySystem(newApogySystemWizard.getApogySystem());
                    ApogySystemFileSelectionComposite.this.setApogySystemFilePath(newApogySystemWizard.getFileAbsolutePath());
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.btnSave = new Button((Composite)this, 8);
        this.btnSave.setText("Save");
        this.btnSave.setToolTipText("Saves the Apogy System file.");
        GridData gd_btnSave = new GridData(0x1000000, 128, false, false);
        this.btnSave.setLayoutData((Object)gd_btnSave);
        this.btnSave.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    ApogySystemFileSelectionComposite.this.save();
                }
                catch (Exception e) {
                    Logger.error(e.getMessage(), (Throwable)e);
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
    }

    public ApogySystem getApogySystem() {
        return this.apogySystem;
    }

    public String getApogySystemFilePath() {
        return this.apogySystemFilePath;
    }

    public void save() throws Exception {
        if (this.getApogySystem() != null && this.getApogySystemFilePath() != null) {
            ApogyCoreFacade.INSTANCE.saveApogySystemToFile(this.getApogySystem(), this.getApogySystemFilePath());
        }
        this.setFileIsDirty(false);
    }

    private EContentAdapter getSystemAdapter() {
        if (this.systemAdapter == null) {
            this.systemAdapter = new EContentAdapter(){

                public void notifyChanged(Notification notification) {
                    super.notifyChanged(notification);
                    ApogySystemFileSelectionComposite.this.setFileIsDirty(true);
                }
            };
        }
        return this.systemAdapter;
    }

    private void setApogySystem(ApogySystem newApogySystem) {
        if (this.apogySystem != null) {
            this.apogySystem.eAdapters().add((Object)this.getSystemAdapter());
        }
        this.apogySystem = newApogySystem;
        if (newApogySystem != null) {
            newApogySystem.eAdapters().add((Object)this.getSystemAdapter());
        }
        this.setFileIsDirty(false);
        this.apogySystemOpened(newApogySystem);
    }

    private void setApogySystemFilePath(final String apogySystemFilePath) {
        this.apogySystemFilePath = apogySystemFilePath;
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ApogySystemFileSelectionComposite.this.lblApogySystemFilePath != null && !ApogySystemFileSelectionComposite.this.lblApogySystemFilePath.isDisposed()) {
                    if (apogySystemFilePath != null) {
                        ApogySystemFileSelectionComposite.this.lblApogySystemFilePath.setText(apogySystemFilePath);
                        ApogySystemFileSelectionComposite.this.lblApogySystemFilePath.setToolTipText(apogySystemFilePath);
                    } else {
                        ApogySystemFileSelectionComposite.this.lblApogySystemFilePath.setText("");
                        ApogySystemFileSelectionComposite.this.lblApogySystemFilePath.setToolTipText("");
                    }
                }
            }
        });
        this.apogySystemPathSet(apogySystemFilePath);
    }

    protected void apogySystemOpened(ApogySystem newApogySystem) {
    }

    protected void apogySystemPathSet(String newApogySystemPath) {
    }

    protected void setFileIsDirty(boolean dirty) {
    }
}

