/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.StrongConnectivityInspector;
import org.jgrapht.traverse.DepthFirstIterator;

public class CycleDetector<V, E> {
    DirectedGraph<V, E> graph;

    public CycleDetector(DirectedGraph<V, E> graph) {
        this.graph = graph;
    }

    public boolean detectCycles() {
        try {
            this.execute(null, null);
        }
        catch (CycleDetectedException ex) {
            return true;
        }
        return false;
    }

    public boolean detectCyclesContainingVertex(V v) {
        try {
            this.execute(null, v);
        }
        catch (CycleDetectedException ex) {
            return true;
        }
        return false;
    }

    public Set<V> findCycles() {
        StrongConnectivityInspector<V, E> inspector = new StrongConnectivityInspector<V, E>(this.graph);
        List<Set<V>> components = inspector.stronglyConnectedSets();
        HashSet<V> set = new HashSet<V>();
        for (Set<V> component : components) {
            if (component.size() > 1) {
                set.addAll(component);
                continue;
            }
            V v = component.iterator().next();
            if (!this.graph.containsEdge(v, v)) continue;
            set.add(v);
        }
        return set;
    }

    public Set<V> findCyclesContainingVertex(V v) {
        HashSet set = new HashSet();
        this.execute(set, v);
        return set;
    }

    private void execute(Set<V> s, V v) {
        ProbeIterator iter = new ProbeIterator(s, v);
        while (iter.hasNext()) {
            iter.next();
        }
    }

    private static class CycleDetectedException
    extends RuntimeException {
        private static final long serialVersionUID = 3834305137802950712L;

        private CycleDetectedException() {
        }
    }

    private class ProbeIterator
    extends DepthFirstIterator<V, E> {
        private List<V> path;
        private Set<V> cycleSet;
        private V root;

        ProbeIterator(Set<V> cycleSet, V startVertex) {
            super(CycleDetector.this.graph, startVertex);
            this.root = startVertex;
            this.cycleSet = cycleSet;
            this.path = new ArrayList();
        }

        /*
         * Unable to fully structure code
         */
        @Override
        protected void encounterVertexAgain(V vertex, E edge) {
            block5: {
                super.encounterVertexAgain(vertex, edge);
                if (this.root == null) ** GOTO lbl10
                if (vertex == this.root) {
                    i = 0;
                } else if (this.cycleSet != null && this.cycleSet.contains(vertex)) {
                    i = 0;
                } else {
                    return;
lbl10:
                    // 1 sources

                    i = this.path.indexOf(vertex);
                }
                if (i <= -1) break block5;
                if (this.cycleSet != null) ** GOTO lbl17
                throw new CycleDetectedException();
lbl-1000:
                // 1 sources

                {
                    this.cycleSet.add(this.path.get(i));
                    ++i;
lbl17:
                    // 2 sources

                    ** while (i < this.path.size())
                }
            }
        }

        @Override
        protected V provideNextVertex() {
            Object v = super.provideNextVertex();
            int i = this.path.size() - 1;
            while (i >= 0) {
                if (CycleDetector.this.graph.containsEdge(this.path.get(i), v)) break;
                this.path.remove(i);
                --i;
            }
            this.path.add(v);
            return v;
        }
    }
}

