/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.impl;

import java.util.Date;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.TimeDirection;
import org.eclipse.apogy.common.emf.impl.BrowseableTimeSourceImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowseableTimeSourceCustomImpl
extends BrowseableTimeSourceImpl {
    private static final Logger Logger = LoggerFactory.getLogger(BrowseableTimeSourceImpl.class);
    protected boolean paused = false;
    protected boolean disposed = false;
    protected Job updateJob = null;
    protected static final Date START_TIME_EDEFAULT = new Date();

    @Override
    public Date getStartTime() {
        Date tmp = super.getStartTime();
        if (tmp == null) {
            tmp = new Date();
            ApogyCommonTransactionFacade.INSTANCE.basicSet(this, (EStructuralFeature)ApogyCommonEMFPackage.Literals.BROWSEABLE_TIME_SOURCE__START_TIME, tmp, true);
        }
        return tmp;
    }

    @Override
    public Date getTime() {
        Date tmp = super.getTime();
        if (tmp == null) {
            tmp = this.getStartTime();
            this.updateTime(new Date(this.getStartTime().getTime()));
        }
        return tmp;
    }

    @Override
    public void dispose() {
        Logger.debug("Disposing...");
        this.disposed = true;
        if (this.updateJob != null) {
            this.getUpdateJob().cancel();
            this.setUpdateJob(null);
        }
    }

    @Override
    public void playForward() {
        this.basicSet(this, (EStructuralFeature)ApogyCommonEMFPackage.Literals.BROWSEABLE_TIME_SOURCE__TIME_DIRECTION, (Object)TimeDirection.FORWARD);
        this.paused = false;
        this.getUpdateJob();
    }

    @Override
    public void playReverse() {
        this.basicSet(this, (EStructuralFeature)ApogyCommonEMFPackage.Literals.BROWSEABLE_TIME_SOURCE__TIME_DIRECTION, (Object)TimeDirection.REVERSE);
        this.paused = false;
        this.getUpdateJob();
    }

    @Override
    public void pause() {
        this.paused = true;
    }

    @Override
    public void reset() {
        this.paused = true;
        this.updateTime(this.getStartTime());
        this.getUpdateJob();
    }

    protected void setUpdateJob(Job updateJob) {
        this.updateJob = updateJob;
    }

    protected Job getUpdateJob() {
        if (this.updateJob == null) {
            this.updateJob = new Job("BrowseableTimeSource update"){
                private long lastTime;
                {
                    this.lastTime = -1L;
                }

                protected IStatus run(IProgressMonitor monitor) {
                    if (!monitor.isCanceled() && !BrowseableTimeSourceCustomImpl.this.disposed) {
                        try {
                            if (!BrowseableTimeSourceCustomImpl.this.paused) {
                                Date now = new Date();
                                if (this.lastTime != -1L) {
                                    long delta = Math.round((float)(now.getTime() - this.lastTime) * BrowseableTimeSourceCustomImpl.this.getTimeAcceration());
                                    Date newTime = null;
                                    newTime = BrowseableTimeSourceCustomImpl.this.getTimeDirection() == TimeDirection.FORWARD ? new Date(BrowseableTimeSourceCustomImpl.this.getTime().getTime() + delta) : new Date(BrowseableTimeSourceCustomImpl.this.getTime().getTime() - delta);
                                    BrowseableTimeSourceCustomImpl.this.updateTime(newTime);
                                } else {
                                    BrowseableTimeSourceCustomImpl.this.updateTime(now);
                                }
                                this.lastTime = now.getTime();
                            }
                            BrowseableTimeSourceCustomImpl.this.updateJob.schedule((long)BrowseableTimeSourceCustomImpl.this.getUpdatePeriod());
                        }
                        catch (Exception e) {
                            Logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            this.updateJob.schedule();
        }
        return this.updateJob;
    }
}

