/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf;

import java.util.List;
import org.eclipse.apogy.common.emf.ListEventDelegate;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

public class EListAdapter<T>
implements Adapter {
    private final ListEventDelegate<T> delegate;
    private final int expectedFeatureId;
    private final Class<?> expectedClass;

    public EListAdapter(int expectedFeatureId, ListEventDelegate<T> delegate, Class<?> expectedClass) {
        if (delegate == null) {
            throw new IllegalArgumentException("delegate is null");
        }
        if (expectedClass == null) {
            throw new IllegalArgumentException("expectedClass is null");
        }
        this.delegate = delegate;
        this.expectedFeatureId = expectedFeatureId;
        this.expectedClass = expectedClass;
    }

    public Notifier getTarget() {
        return null;
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    public void notifyChanged(Notification notification) {
        int featureId = notification.getFeatureID(this.expectedClass);
        if (featureId == this.expectedFeatureId) {
            if (notification.getEventType() == 3) {
                if (notification.getNewValue() != null) {
                    Object element = notification.getNewValue();
                    this.delegate.added(element);
                }
            } else if (notification.getEventType() == 5) {
                if (notification.getNewValue() != null) {
                    List elements = (List)notification.getNewValue();
                    this.delegate.addedMany(elements);
                }
            } else if (notification.getEventType() == 4) {
                if (notification.getOldValue() != null) {
                    Object element = notification.getOldValue();
                    this.delegate.removed(element);
                }
            } else if (notification.getEventType() == 6 && notification.getOldValue() != null) {
                List elements = (List)notification.getOldValue();
                this.delegate.removedMany(elements);
            }
        }
    }

    public void setTarget(Notifier newTarget) {
    }
}

