/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.moon.surface;

import java.util.Date;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.TransformNode;
import org.eclipse.apogy.core.environment.AbstractWorksite;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentFacade;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentFactory;
import org.eclipse.apogy.core.environment.ApogyEnvironment;
import org.eclipse.apogy.core.environment.Earth;
import org.eclipse.apogy.core.environment.HorizontalCoordinates;
import org.eclipse.apogy.core.environment.SkyNode;
import org.eclipse.apogy.core.environment.Worksite;
import org.eclipse.apogy.core.environment.moon.ApogyCoreEnvironmentMoonFacade;
import org.eclipse.apogy.core.environment.moon.SelenographicCoordinates;
import org.eclipse.apogy.core.environment.moon.surface.ApogyMoonSurfaceEnvironmentFactory;
import org.eclipse.apogy.core.environment.moon.surface.MoonSky;
import org.eclipse.apogy.core.environment.moon.surface.MoonSkyNode;
import org.eclipse.apogy.core.environment.moon.surface.MoonSurfaceUtils;
import org.eclipse.apogy.core.environment.moon.surface.MoonSurfaceWorksite;
import org.eclipse.apogy.core.environment.moon.surface.impl.ApogyMoonSurfaceEnvironmentFacadeImpl;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentFactory;
import org.eclipse.apogy.core.environment.surface.CartesianTriangularMeshURLMapLayer;
import org.eclipse.apogy.core.environment.surface.Map;
import org.eclipse.apogy.core.environment.surface.MapsList;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogyMoonSurfaceEnvironmentFacadeCustomImpl
extends ApogyMoonSurfaceEnvironmentFacadeImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ApogyMoonSurfaceEnvironmentFacadeCustomImpl.class);
    private Adapter activeWorksiteAdapter = null;
    private Adapter moonSurfaceWorksiteAdapter = null;

    public ApogyMoonSurfaceEnvironmentFacadeCustomImpl() {
        ApogyCoreEnvironmentFacade.INSTANCE.eAdapters().add((Object)this.getWorksiteAdapter());
    }

    @Override
    public MoonSky createMoonSky(SelenographicCoordinates siteSelenographicCoordinates) {
        MoonSky moonSky = ApogyMoonSurfaceEnvironmentFactory.eINSTANCE.createMoonSky();
        moonSky.setTime(new Date());
        return moonSky;
    }

    @Override
    public MoonSkyNode createMoonSkyNode(SelenographicCoordinates siteSelenographicCoordinates) {
        Date now = new Date();
        MoonSkyNode moonSkyNode = ApogyMoonSurfaceEnvironmentFactory.eINSTANCE.createMoonSkyNode();
        ApogyCoreEnvironmentFacade.INSTANCE.initializeSkyNode((SkyNode)moonSkyNode);
        Earth earth = ApogyCoreEnvironmentFactory.eINSTANCE.createEarth();
        earth.setDescription("The Earth.");
        earth.setNodeId("EARTH");
        HorizontalCoordinates earthHorizontalCoordinates = ApogyCoreEnvironmentFactory.eINSTANCE.createHorizontalCoordinates();
        if (siteSelenographicCoordinates != null) {
            earthHorizontalCoordinates = MoonSurfaceUtils.INSTANCE.getHorizontalEarthPosition(now, siteSelenographicCoordinates.getLongitude(), siteSelenographicCoordinates.getLatitude(), siteSelenographicCoordinates.getElevation());
        }
        Point3d earthPosition = ApogyCoreEnvironmentFacade.INSTANCE.convertFromHorizontalCoordinatesToHorizontalRectangular(earthHorizontalCoordinates);
        TransformNode earthTransformNode = ApogyCommonTopologyFacade.INSTANCE.createTransformNodeXYZ(earthPosition.x, earthPosition.y, earthPosition.z, 0.0, 0.0, 0.0);
        earthTransformNode.setDescription("Transform attaching the Earth to the Sky.");
        earthTransformNode.setNodeId("EARTH_TRANSFORM");
        moonSkyNode.getChildren().add((Object)earthTransformNode);
        earthTransformNode.getChildren().add((Object)earth);
        moonSkyNode.setDescription("Moon's Sky.");
        moonSkyNode.setNodeId("SKY");
        return moonSkyNode;
    }

    @Override
    public MoonSurfaceWorksite createAndInitializeDefaultMoonWorksite() {
        Date now = new Date();
        MoonSurfaceWorksite worksite = ApogyMoonSurfaceEnvironmentFactory.eINSTANCE.createMoonSurfaceWorksite();
        worksite.setName("The Moon");
        worksite.setDescription("The default Moon Worksite.");
        worksite.setSelenographicCoordinates(ApogyCoreEnvironmentMoonFacade.INSTANCE.createSelenographicCoordinates(0.0, 0.0, 0.0));
        worksite.setXAxisAzimuth(Math.toRadians(179.4));
        MoonSky earthSky = this.createMoonSky(worksite.getSelenographicCoordinates());
        worksite.setSky(earthSky);
        earthSky.setWorksite((Worksite)worksite);
        worksite.getMoonSky().setTime(now);
        MapsList mapList = ApogySurfaceEnvironmentFactory.eINSTANCE.createMapsList();
        worksite.setMapsList(mapList);
        Map map = this.getDefaultMoonMap();
        worksite.getMapsList().getMaps().add((Object)map);
        return worksite;
    }

    @Override
    public MoonSurfaceWorksite createEmptyMoonSurfaceWorksite() {
        MoonSurfaceWorksite worksite = this.createAndInitializeDefaultMoonWorksite();
        worksite.setName(null);
        worksite.setDescription(null);
        worksite.setXAxisAzimuth(0.0);
        worksite.setSelenographicCoordinates(ApogyCoreEnvironmentMoonFacade.INSTANCE.createSelenographicCoordinates(0.0, 0.0, 0.0));
        worksite.getMapsList().getMaps().clear();
        return worksite;
    }

    @Override
    public InvocatorSession createApogySession() {
        InvocatorSession session = ApogyCoreEnvironmentFacade.INSTANCE.createApogySession(true, true, true, true);
        ApogyEnvironment environment = (ApogyEnvironment)session.getEnvironment();
        MoonSurfaceWorksite worksite = this.createAndInitializeDefaultMoonWorksite();
        environment.getWorksitesList().getWorksites().add((Object)worksite);
        environment.setActiveWorksite((AbstractWorksite)worksite);
        return session;
    }

    private Map getDefaultMoonMap() {
        Map map = ApogySurfaceEnvironmentFactory.eINSTANCE.createMap();
        map.setName("Default");
        map.setDescription("Simple Moon Map.");
        Matrix4d matrix = this.getDefaultMoonTerrainTransformNode().asMatrix4d();
        map.setTransformation(ApogyCommonMathFacade.INSTANCE.createMatrix4x4(matrix));
        CartesianTriangularMeshURLMapLayer meshLayer = ApogySurfaceEnvironmentFactory.eINSTANCE.createCartesianTriangularMeshURLMapLayer();
        meshLayer.setUrl("platform:/plugin/org.eclipse.apogy.examples.worksites.surface/data/CSAAnalogTerrainDEM100cm.tri");
        meshLayer.setName("MarsYardDEM 1.0 meters resolution");
        meshLayer.setDescription("MarsYard DEM at 1.0 meters resolution");
        map.getLayers().add((Object)meshLayer);
        return map;
    }

    public TransformNode getDefaultMoonTerrainTransformNode() {
        TransformNode marsYardTransformNode = ApogyCommonTopologyFacade.INSTANCE.createTransformNodeXYZ(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        marsYardTransformNode.setDescription("Transform that orients the terrain coordinate system to north.");
        return marsYardTransformNode;
    }

    private void updateMoonSurfaceWorksite(AbstractWorksite abstractWorksite) {
        if (this.getActiveMoonSurfaceWorksite() != null) {
            this.getActiveMoonSurfaceWorksite().eAdapters().remove((Object)this.getMoonSurfaceWorksiteAdapter());
        }
        if (abstractWorksite instanceof MoonSurfaceWorksite) {
            MoonSurfaceWorksite moonSurfaceWorksite = (MoonSurfaceWorksite)abstractWorksite;
            moonSurfaceWorksite.eAdapters().add((Object)this.getMoonSurfaceWorksiteAdapter());
            this.setActiveMoonSurfaceWorksite(moonSurfaceWorksite);
            if (moonSurfaceWorksite.getSky() instanceof MoonSky) {
                MoonSky moonSky = (MoonSky)moonSurfaceWorksite.getSky();
                this.setActiveEarth(moonSky.getEarth());
            }
        } else {
            this.setActiveMoonSurfaceWorksite(null);
            this.setActiveEarth(null);
        }
    }

    private Adapter getWorksiteAdapter() {
        if (this.activeWorksiteAdapter == null) {
            this.activeWorksiteAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof ApogyCoreEnvironmentFacade) {
                        int featureID = msg.getFeatureID(ApogyCoreEnvironmentFacade.class);
                        switch (featureID) {
                            case 1: {
                                ApogyMoonSurfaceEnvironmentFacadeCustomImpl.this.updateMoonSurfaceWorksite((AbstractWorksite)msg.getNewValue());
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.activeWorksiteAdapter;
    }

    private Adapter getMoonSurfaceWorksiteAdapter() {
        if (this.moonSurfaceWorksiteAdapter == null) {
            this.moonSurfaceWorksiteAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof MoonSurfaceWorksite) {
                        int featureID = msg.getFeatureID(MoonSurfaceWorksite.class);
                        switch (featureID) {
                            case 6: {
                                if (!(msg.getNewValue() instanceof MoonSky)) break;
                                MoonSky moonSky = (MoonSky)msg.getNewValue();
                                ApogyMoonSurfaceEnvironmentFacadeCustomImpl.this.setActiveEarth(moonSky.getEarth());
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.moonSurfaceWorksiteAdapter;
    }
}

