/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.widgets.ui;

import java.net.URL;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrowButtonComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(ArrowButtonComposite.class);
    private static final int ANGLE_TO_GET_INVERSE = 180;
    private static final int NB_MILLIS_AUTO_REPEAT_DOWN_ACTION = 20;
    private static final int NB_MILLIS_BEFORE_AUTO_REPEAT = 400;
    private static final String IMAGES_FOLDER = "platform:/plugin/org.eclipse.apogy.common.widgets.ui/images/";
    private Image arrowImage;
    private Image arrowImagePressed;
    private MouseListener mouseListener;
    private Thread repeatEventThread;
    private boolean repeatThreadCanRun = false;
    private final boolean autoRepeatDownAction;
    private final ArrowDirection arrowDirection;
    private boolean isPressed;

    public ArrowButtonComposite(Composite parent, int style, ArrowDirection arrowDirection, boolean autoRepeatDownAction) {
        super(parent, style | 0x20000000);
        this.arrowDirection = arrowDirection;
        this.isPressed = false;
        this.repeatEventThread = null;
        this.autoRepeatDownAction = autoRepeatDownAction;
        this.initImages();
        this.createPaintListener();
        this.createDisposeListener();
        this.createMouseListener();
    }

    public void notifyListeners(int eventType, Event event) {
        if (this.isEnabled()) {
            super.notifyListeners(eventType, event);
        }
    }

    private void initImages() {
        try {
            Display device = Display.getCurrent();
            URL url = new URL("platform:/plugin/org.eclipse.apogy.common.widgets.ui/images/arrowButton.png");
            this.arrowImage = new Image((Device)device, url.openStream());
            url = new URL("platform:/plugin/org.eclipse.apogy.common.widgets.ui/images/arrowButtonPressed.png");
            this.arrowImagePressed = new Image((Device)device, url.openStream());
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void paintMeter(GC gc) {
        this.verifyOrientationOfCanvas(gc);
        if (this.isPressed) {
            if (this.arrowImagePressed != null) {
                this.drawPressedArrow(gc);
            }
        } else if (this.arrowImage != null) {
            this.drawArrow(gc);
        } else {
            this.drawBlackRectangle(gc);
        }
    }

    private void verifyOrientationOfCanvas(GC gc) {
        Transform t = new Transform(gc.getDevice());
        t.rotate(180.0f);
        if (this.arrowDirection == ArrowDirection.RIGHT) {
            gc.setTransform(t);
        }
        t.dispose();
    }

    private void drawPressedArrow(GC gc) {
        if (this.arrowDirection == ArrowDirection.RIGHT) {
            gc.drawImage(this.arrowImagePressed, 0, 0, this.arrowImagePressed.getBounds().width, this.arrowImagePressed.getBounds().height, -this.getBounds().width, -this.getBounds().height, this.getBounds().width, this.getBounds().height);
        } else {
            gc.drawImage(this.arrowImagePressed, 0, 0, this.arrowImagePressed.getBounds().width, this.arrowImagePressed.getBounds().height, 0, 0, this.getBounds().width, this.getBounds().height);
        }
    }

    private void drawArrow(GC gc) {
        if (this.arrowDirection == ArrowDirection.RIGHT) {
            gc.drawImage(this.arrowImage, 0, 0, this.arrowImage.getBounds().width, this.arrowImage.getBounds().height, -this.getBounds().width, -this.getBounds().height, this.getBounds().width, this.getBounds().height);
        } else {
            gc.drawImage(this.arrowImage, 0, 0, this.arrowImage.getBounds().width, this.arrowImage.getBounds().height, 0, 0, this.getBounds().width, this.getBounds().height);
        }
    }

    private void drawBlackRectangle(GC gc) {
        if (this.arrowDirection == ArrowDirection.RIGHT) {
            Color color = new Color((Device)this.getDisplay(), 0, 0, 0);
            gc.setForeground(color);
            gc.setLineWidth(4);
            gc.drawRectangle(-(this.getBounds().width - 2), -(this.getBounds().height - 2), this.getBounds().width - 4, this.getBounds().height - 4);
            color.dispose();
        } else {
            Color color = new Color((Device)this.getDisplay(), 0, 0, 0);
            gc.setForeground(color);
            gc.setLineWidth(4);
            gc.drawRectangle(2, 2, this.getBounds().width - 4, this.getBounds().height - 4);
            color.dispose();
        }
    }

    private void createPaintListener() {
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ArrowButtonComposite.this.paintMeter(e.gc);
            }
        });
    }

    private void createDisposeListener() {
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ArrowButtonComposite.this.arrowImage != null) {
                    ArrowButtonComposite.this.arrowImage.dispose();
                }
                if (ArrowButtonComposite.this.arrowImagePressed != null) {
                    ArrowButtonComposite.this.arrowImagePressed.dispose();
                }
            }
        });
    }

    private void createMouseListener() {
        this.mouseListener = new MouseListener(){

            public void mouseDown(MouseEvent e) {
                if (ArrowButtonComposite.this.autoRepeatDownAction) {
                    if (ArrowButtonComposite.this.repeatEventThread == null) {
                        ArrowButtonComposite.this.isPressed = true;
                        ArrowButtonComposite.this.redraw();
                        ArrowButtonComposite.this.repeatThreadCanRun = true;
                        ArrowButtonComposite.this.repeatEventThread = new Thread(){

                            @Override
                            public void run() {
                                int i = 0;
                                while (i < 400) {
                                    try {
                                        Thread.sleep(1L);
                                    }
                                    catch (InterruptedException e) {
                                        Logger.error(e.getMessage(), (Throwable)e);
                                    }
                                    if (!ArrowButtonComposite.this.repeatThreadCanRun || ArrowButtonComposite.this.isDisposed()) {
                                        return;
                                    }
                                    ++i;
                                }
                                while (ArrowButtonComposite.this.repeatThreadCanRun && !ArrowButtonComposite.this.isDisposed()) {
                                    Display.getDefault().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (ArrowButtonComposite.this.repeatThreadCanRun && !ArrowButtonComposite.this.isDisposed()) {
                                                ArrowButtonComposite.this.notifyListeners(3, null);
                                            }
                                        }
                                    });
                                    i = 0;
                                    while (i < 20) {
                                        try {
                                            Thread.sleep(1L);
                                        }
                                        catch (InterruptedException e) {
                                            Logger.error(e.getMessage(), (Throwable)e);
                                        }
                                        if (!ArrowButtonComposite.this.repeatThreadCanRun || ArrowButtonComposite.this.isDisposed()) {
                                            return;
                                        }
                                        ++i;
                                    }
                                }
                            }
                        };
                        ArrowButtonComposite.this.repeatEventThread.start();
                    }
                } else {
                    ArrowButtonComposite.this.isPressed = true;
                    ArrowButtonComposite.this.redraw();
                }
            }

            public void mouseUp(MouseEvent e) {
                ArrowButtonComposite.this.isPressed = false;
                ArrowButtonComposite.this.redraw();
                ArrowButtonComposite.this.repeatThreadCanRun = false;
                if (ArrowButtonComposite.this.repeatEventThread != null) {
                    ArrowButtonComposite.this.repeatEventThread = null;
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        };
        this.addMouseListener(this.mouseListener);
    }

    public static enum ArrowDirection {
        LEFT,
        RIGHT;

    }
}

