/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.provider;

import java.text.DecimalFormat;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.TimeInterval;
import org.eclipse.apogy.core.environment.earth.orbit.VisibilityPass;
import org.eclipse.apogy.core.environment.earth.orbit.provider.VisibilityPassItemProvider;
import org.eclipse.emf.common.notify.AdapterFactory;

public class VisibilityPassCustomItemProvider
extends VisibilityPassItemProvider {
    private DecimalFormat durationFormat = new DecimalFormat("0.0");

    public VisibilityPassCustomItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public String getColumnText(Object object, int columnIndex) {
        return super.getColumnText(object, columnIndex);
    }

    @Override
    public String getText(Object object) {
        VisibilityPass visibilityPass = (VisibilityPass)object;
        String text = "";
        if (visibilityPass.getOutlook() != null) {
            text = visibilityPass.getOutlook().getName();
        }
        if (text == null || text.length() == 0) {
            text = this.getString("_UI_VisibilityPassWorldWindLayer_type");
        }
        long duration = ApogyCommonEMFFacade.INSTANCE.getDuration((TimeInterval)visibilityPass);
        text = String.valueOf(text) + " (";
        if (duration > 60000L) {
            double minutes = (double)duration / 60000.0;
            text = String.valueOf(text) + this.durationFormat.format(minutes) + " min";
        } else {
            double seconds = (double)duration / 1000.0;
            text = String.valueOf(text) + this.durationFormat.format(seconds) + " s";
        }
        text = String.valueOf(text) + ")";
        return text;
    }
}

