/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.telecoms.ui.views;

import java.util.List;
import javax.inject.Inject;
import org.eclipse.apogy.addons.ApogyAddonsPackage;
import org.eclipse.apogy.addons.telecoms.ApogyAddonsTelecomsFacade;
import org.eclipse.apogy.addons.telecoms.ApogyAddonsTelecomsPackage;
import org.eclipse.apogy.addons.telecoms.TelecomStatusMonitorTool;
import org.eclipse.apogy.addons.telecoms.TelecomStatusMonitorToolList;
import org.eclipse.apogy.addons.telecoms.ui.composites.TelecomStatusMonitorToolsComposite;
import org.eclipse.apogy.addons.ui.AbstractToolEClassSettings;
import org.eclipse.apogy.addons.ui.ApogyAddonsUIFactory;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.EClassSettings;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.adapters.AbstractEListContentProvider;
import org.eclipse.apogy.common.emf.ui.composites.AbstractECollectionComposite;
import org.eclipse.apogy.common.emf.ui.emfforms.wizards.EObjectWizard;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.apogy.core.invocator.ui.parts.AbstractSessionECollectionPart;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelecomStatusMonitorToolPart
extends AbstractSessionECollectionPart<ApogyAddonsTelecomsFacade> {
    private static final Logger Logger = LoggerFactory.getLogger(TelecomStatusMonitorToolPart.class);
    private TelecomStatusMonitorToolsComposite<ApogyAddonsTelecomsFacade, ApogyAddonsTelecomsFacade, TelecomStatusMonitorTool> composite;
    @Inject
    public ESelectionService selectionService;

    public AbstractECollectionComposite<?, ?, ?> createECollectionComposite(Composite parent, int style) {
        ECollectionCompositeSettings settings = ApogyCommonEMFUIFactory.eINSTANCE.createECollectionCompositeSettings();
        settings.setDetailSectionDisplayed(true);
        settings.setButtonsSectionDisplayed(true);
        this.composite = new TelecomStatusMonitorToolsComposite<ApogyAddonsTelecomsFacade, ApogyAddonsTelecomsFacade, TelecomStatusMonitorTool>(parent, 0, null, (EStructuralFeature)ApogyAddonsTelecomsPackage.Literals.APOGY_ADDONS_TELECOMS_FACADE__AVAILABLE_TELECOM_STATUS_MONITOR_TOOLS, settings){

            protected AdapterFactoryContentProvider createContentProvider(AdapterFactory adapterFactory) {
                return new AbstractEListContentProvider(adapterFactory){

                    public EStructuralFeature getEStructuralFeature() {
                        return ApogyAddonsTelecomsPackage.Literals.APOGY_ADDONS_TELECOMS_FACADE__AVAILABLE_TELECOM_STATUS_MONITOR_TOOLS;
                    }

                    public Object[] getElements(Object object) {
                        if (object instanceof ApogyAddonsTelecomsFacade) {
                            ApogyAddonsTelecomsFacade addonsTelecomsFacade = (ApogyAddonsTelecomsFacade)object;
                            TelecomStatusMonitorToolList list = addonsTelecomsFacade.getAvailableTelecomStatusMonitorTools();
                            if (list != null) {
                                return addonsTelecomsFacade.getList(list).toArray();
                            }
                            return null;
                        }
                        return null;
                    }
                };
            }

            protected void createButtons(Composite parent, int style) {
                this.createNewButton(parent, style);
                this.createDeleteButton(parent, style);
                this.createSeparator(parent, style);
                Button enbaleButton = this.createActivateButton(parent, style);
                enbaleButton.setText("Enable");
                Button disableButton = this.createDeActivateButton(parent, style);
                disableButton.setText("Disable");
            }

            protected void doNew() {
                TelecomStatusMonitorToolList simpleToolList = ApogyAddonsTelecomsFacade.INSTANCE.getAvailableTelecomStatusMonitorTools();
                AbstractToolEClassSettings settings = ApogyAddonsUIFactory.eINSTANCE.createAbstractToolEClassSettings();
                settings.setName(ApogyCommonEMFFacade.INSTANCE.getDefaultName((EObject)simpleToolList, null, (ETypedElement)ApogyAddonsPackage.Literals.SIMPLE_TOOL_LIST__SIMPLE_TOOLS));
                EObjectWizard wizard = new EObjectWizard((EObject)simpleToolList, null, ApogyAddonsPackage.Literals.SIMPLE_TOOL_LIST__SIMPLE_TOOLS, ApogyAddonsTelecomsPackage.Literals.TELECOM_STATUS_MONITOR_TOOL, (EClassSettings)settings);
                WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
                dialog.open();
                this.refreshViewer();
            }

            protected void selectionChanged(IStructuredSelection selection) {
                if (!selection.isEmpty()) {
                    TelecomStatusMonitorTool simpleTool = (TelecomStatusMonitorTool)this.getSelectedItemObjects().get(0);
                    TelecomStatusMonitorToolPart.this.selectionService.setSelection((Object)simpleTool);
                }
            }

            protected void doActivate(List<TelecomStatusMonitorTool> list) {
                for (TelecomStatusMonitorTool simpleTool : list) {
                    try {
                        simpleTool.start();
                    }
                    catch (Exception e) {
                        Logger.error("Failed to activate Tool <" + simpleTool + ">!", (Throwable)e);
                    }
                }
            }

            protected Button createDeActivateButton(Composite parent, int style) {
                Button btnDeActivate = 1.createButton((Composite)parent, (int)0, (String)"De-Activate", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
                    this.doDeActivate(this.getViewer().getStructuredSelection().toList());
                    this.refreshViewer();
                }));
                this.createDeActivateButtonBindings(btnDeActivate);
                return btnDeActivate;
            }

            protected void createDeActivateButtonBindings(Button button) {
                ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> {
                    if (o != null) {
                        return true;
                    }
                    return false;
                });
            }

            protected void doDeActivate(List<TelecomStatusMonitorTool> list) {
                for (TelecomStatusMonitorTool simpleTool : list) {
                    try {
                        simpleTool.stop();
                    }
                    catch (Exception e) {
                        Logger.error("Failed to de-activate Simple Tool <" + simpleTool + ">!", (Throwable)e);
                    }
                }
            }
        };
        return this.composite;
    }

    protected void doSetContent(ApogyAddonsTelecomsFacade rootEObject) {
        this.composite.setRootEObject(rootEObject);
    }

    protected void sessionChanged(InvocatorSession invocatorSession) {
        this.setContent((EObject)ApogyAddonsTelecomsFacade.INSTANCE);
    }
}

