/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.lang.java.io;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LittleEndianDataOutputStream
extends OutputStream
implements DataOutput {
    private final DataOutputStream out;

    public LittleEndianDataOutputStream(OutputStream output) {
        this.out = new DataOutputStream(output);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.out.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.out.write(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        int v0 = 0xFF & v;
        int v1 = 0xFF & v >> 8;
        this.out.write(v0);
        this.out.write(v1);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.writeShort(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        int v0 = 0xFF & v;
        int v1 = 0xFF & v >> 8;
        int v2 = 0xFF & v >> 16;
        int v3 = 0xFF & v >> 24;
        this.out.write(v0);
        this.out.write(v1);
        this.out.write(v2);
        this.out.write(v3);
    }

    @Override
    public void writeLong(long v) throws IOException {
        byte[] byteArray = new byte[]{(byte)(0xFFL & v), (byte)(0xFFL & v >> 8), (byte)(0xFFL & v >> 16), (byte)(0xFFL & v >> 24), (byte)(0xFFL & v >> 32), (byte)(0xFFL & v >> 40), (byte)(0xFFL & v >> 48), (byte)(0xFFL & v >> 56)};
        this.out.write(byteArray, 0, byteArray.length);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.write(s.getBytes(), 0, s.getBytes().length);
    }

    @Override
    public void writeChars(String s) throws IOException {
        int i = 0;
        while (i < s.length()) {
            this.writeChar(s.charAt(i));
            ++i;
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.out.writeUTF(s);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }
}

