/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.parts;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.apogy.common.converters.ApogyCommonConvertersFacade;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.NodeSelection;
import org.eclipse.apogy.common.topology.ui.composites.NodeToNodeDistanceComposite;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.e4.ui.workbench.modeling.ISelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class NodesDistancePart {
    private Composite parentComposite;
    @Inject
    protected ESelectionService selectionService;
    private ISelectionListener selectionListener;
    private NodeToNodeDistanceComposite nodeToNodeDistanceComposite = null;

    @PostConstruct
    public void createContent(Composite parent) {
        this.parentComposite = parent;
        this.parentComposite.setLayout((Layout)new FillLayout());
        this.nodeToNodeDistanceComposite = new NodeToNodeDistanceComposite(this.parentComposite, 2048);
        this.parentComposite.layout();
        this.selectionService.addSelectionListener(this.getISelectionListener());
    }

    @PreDestroy
    public void dispose() {
        this.selectionService.removeSelectionListener(this.getISelectionListener());
    }

    private ISelectionListener getISelectionListener() {
        if (this.selectionListener == null) {
            this.selectionListener = new ISelectionListener(){

                public void selectionChanged(MPart part, Object selection) {
                    if (selection instanceof Node) {
                        Node node = (Node)selection;
                        NodesDistancePart.this.nodeToNodeDistanceComposite.selectNode(node);
                    } else if (selection instanceof NodeSelection) {
                        NodeSelection nodeSelection = (NodeSelection)selection;
                        Node node = nodeSelection.getSelectedNode();
                        NodesDistancePart.this.nodeToNodeDistanceComposite.selectNode(node);
                    } else {
                        Node node = (Node)ApogyCommonConvertersFacade.INSTANCE.convert(selection, Node.class);
                        NodesDistancePart.this.nodeToNodeDistanceComposite.selectNode(node);
                    }
                }
            };
        }
        return this.selectionListener;
    }
}

