/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MeshPresentationMode implements Enumerator
{
    POINTS(0, "POINTS", "POINTS"),
    SURFACE(1, "SURFACE", "SURFACE"),
    WIREFRAME(2, "WIREFRAME", "WIREFRAME");

    public static final int POINTS_VALUE = 0;
    public static final int SURFACE_VALUE = 1;
    public static final int WIREFRAME_VALUE = 2;
    private static final MeshPresentationMode[] VALUES_ARRAY;
    public static final List<MeshPresentationMode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MeshPresentationMode[]{POINTS, SURFACE, WIREFRAME};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MeshPresentationMode get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MeshPresentationMode result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MeshPresentationMode getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MeshPresentationMode result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MeshPresentationMode get(int value) {
        switch (value) {
            case 0: {
                return POINTS;
            }
            case 1: {
                return SURFACE;
            }
            case 2: {
                return WIREFRAME;
            }
        }
        return null;
    }

    private MeshPresentationMode(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

