/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.AdapterFactory;
import org.eclipse.apogy.common.topology.ui.ApogyCommonTopologyUIFactory;
import org.eclipse.apogy.common.topology.ui.GraphicsContext;
import org.eclipse.apogy.common.topology.ui.GraphicsContextAdapter;
import org.eclipse.apogy.common.topology.ui.NodePresentation;
import org.eclipse.apogy.common.topology.ui.NodePresentationAdapter;
import org.eclipse.apogy.common.topology.ui.TopologyPresentationRegistry;
import org.eclipse.apogy.common.topology.ui.TopologyPresentationSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
extends AbstractUIPlugin {
    private static final Logger Logger = LoggerFactory.getLogger(Activator.class);
    public static final String ID = "org.eclipse.apogy.common.topology.ui";
    public static final String PRESENTATION_EXTENSION_POINT_ID = "org.eclipse.apogy.common.topology.ui.presentation";
    public static final String JAVA3D_EXTENSION_POINT_ID = "org.eclipse.apogy.common.topology.ui.java3d";
    public static final String GRAPHICS_CONTEXT_POINT_ID = "org.eclipse.apogy.common.topology.ui.graphicsContextAdapter";
    private static final String PRESENTATION_EXTENSION_POINT_ID_CLASS = "Class";
    public static final String GRAPHICS_CONTEXT_POINT_ID_CLASS = "Class";
    private static Activator plugin;
    private static BundleContext bundleContext;
    private AdapterFactory<NodePresentationAdapter, NodePresentation, Node, Object> nodePresentationAdapterFactory;
    private AdapterFactory<GraphicsContextAdapter, GraphicsContext, Object, Object> graphicsContextProvidersFactory;
    private Map<IFile, WeakReference<TopologyPresentationSet>> fileToPresentationTopologyMap;
    private static TopologyPresentationRegistry topologyPresentationRegistry;

    static {
        topologyPresentationRegistry = null;
    }

    public static BundleContext getContext() {
        return bundleContext;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        bundleContext = context;
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        bundleContext = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public GraphicsContext getGraphicsContextForObject(Object object) {
        GraphicsContext adapter = null;
        Iterator<GraphicsContextAdapter> it = this.getRegisteredGraphicsContextAdapters().iterator();
        while (it.hasNext() && adapter == null) {
            try {
                GraphicsContextAdapter gca = it.next();
                if (!gca.isAdapterFor(object)) continue;
                adapter = (GraphicsContext)gca.getAdapter(object, null);
            }
            catch (Throwable t) {
                Logger.error(t.getMessage(), t);
            }
        }
        return adapter;
    }

    public AdapterFactory<NodePresentationAdapter, NodePresentation, Node, Object> getNodePresentationAdapterFactory() {
        if (this.nodePresentationAdapterFactory == null) {
            List<NodePresentationAdapter> adapters = this.getRegisteredNodePresentationAdapters();
            this.nodePresentationAdapterFactory = new AdapterFactory(adapters);
        }
        return this.nodePresentationAdapterFactory;
    }

    public AdapterFactory<GraphicsContextAdapter, GraphicsContext, Object, Object> getGraphicsContextProvidersFactory() {
        if (this.graphicsContextProvidersFactory == null) {
            List<GraphicsContextAdapter> adapters = this.getRegisteredGraphicsContextAdapters();
            this.graphicsContextProvidersFactory = new AdapterFactory(adapters);
        }
        return this.graphicsContextProvidersFactory;
    }

    public List<GraphicsContextAdapter> getRegisteredGraphicsContextAdapters() {
        ArrayList<GraphicsContextAdapter> adapters = new ArrayList<GraphicsContextAdapter>();
        IExtensionPoint nodePresentationExtPoint = Platform.getExtensionRegistry().getExtensionPoint(GRAPHICS_CONTEXT_POINT_ID);
        IConfigurationElement[] contributors = nodePresentationExtPoint.getConfigurationElements();
        int i = 0;
        while (i < contributors.length) {
            IConfigurationElement contributor = contributors[i];
            try {
                GraphicsContextAdapter adapter = (GraphicsContextAdapter)contributor.createExecutableExtension("Class");
                adapters.add(adapter);
            }
            catch (CoreException e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
            ++i;
        }
        return adapters;
    }

    public List<NodePresentationAdapter> getRegisteredNodePresentationAdapters() {
        ArrayList<NodePresentationAdapter> adapters = new ArrayList<NodePresentationAdapter>();
        IExtensionPoint nodePresentationExtPoint = Platform.getExtensionRegistry().getExtensionPoint(PRESENTATION_EXTENSION_POINT_ID);
        IConfigurationElement[] contributors = nodePresentationExtPoint.getConfigurationElements();
        int i = 0;
        while (i < contributors.length) {
            IConfigurationElement contributor = contributors[i];
            try {
                NodePresentationAdapter adapter = (NodePresentationAdapter)contributor.createExecutableExtension("Class");
                adapters.add(adapter);
            }
            catch (CoreException e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
            ++i;
        }
        return adapters;
    }

    public TopologyPresentationSet getPresentationTopology(IFile file) {
        TopologyPresentationSet presTopo = null;
        if (this.getFileToPresentationTopologyMap().containsKey(file)) {
            if (this.getFileToPresentationTopologyMap().get(file).get() == null) {
                this.getFileToPresentationTopologyMap().remove(file);
            } else {
                presTopo = (TopologyPresentationSet)this.getFileToPresentationTopologyMap().get(file).get();
            }
        }
        return presTopo;
    }

    public void registerPresentationTopology(IFile file, TopologyPresentationSet presTopo) {
        this.getFileToPresentationTopologyMap().put(file, new WeakReference<TopologyPresentationSet>(presTopo));
    }

    public static TopologyPresentationRegistry getTopologyPresentationRegistry() {
        if (topologyPresentationRegistry == null) {
            topologyPresentationRegistry = ApogyCommonTopologyUIFactory.eINSTANCE.createTopologyPresentationRegistry();
        }
        return topologyPresentationRegistry;
    }

    public static FrameworkLog getFrameworkLog() {
        if (Activator.getContext() != null) {
            ServiceReference logService = Activator.getContext().getServiceReference("org.eclipse.osgi.framework.log.FrameworkLog");
            FrameworkLog log = (FrameworkLog)Activator.getContext().getService(logService);
            return log;
        }
        return null;
    }

    private Map<IFile, WeakReference<TopologyPresentationSet>> getFileToPresentationTopologyMap() {
        if (this.fileToPresentationTopologyMap == null) {
            this.fileToPresentationTopologyMap = new LinkedHashMap<IFile, WeakReference<TopologyPresentationSet>>();
        }
        return this.fileToPresentationTopologyMap;
    }
}

