/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.geometry.paths.ui;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PathPresentationMode implements Enumerator
{
    POINTS(0, "POINTS", "Points"),
    LINES(1, "LINES", "Lines"),
    POINTS_LINES(2, "POINTS_LINES", "Points Lines");

    public static final int POINTS_VALUE = 0;
    public static final int LINES_VALUE = 1;
    public static final int POINTS_LINES_VALUE = 2;
    private static final PathPresentationMode[] VALUES_ARRAY;
    public static final List<PathPresentationMode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PathPresentationMode[]{POINTS, LINES, POINTS_LINES};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PathPresentationMode get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PathPresentationMode result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PathPresentationMode getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PathPresentationMode result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PathPresentationMode get(int value) {
        switch (value) {
            case 0: {
                return POINTS;
            }
            case 1: {
                return LINES;
            }
            case 2: {
                return POINTS_LINES;
            }
        }
        return null;
    }

    private PathPresentationMode(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

