/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.fov.impl;

import org.eclipse.apogy.addons.sensors.fov.ApogyAddonsSensorsFOVFactory;
import org.eclipse.apogy.addons.sensors.fov.ApogyAddonsSensorsFOVPackage;
import org.eclipse.apogy.addons.sensors.fov.DistanceRange;
import org.eclipse.apogy.addons.sensors.fov.impl.RectangularFrustrumFieldOfViewImpl;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class RectangularFrustrumFieldOfViewCustomImpl
extends RectangularFrustrumFieldOfViewImpl {
    @Override
    public DistanceRange getRange() {
        DistanceRange tmp = super.getRange();
        if (tmp == null) {
            tmp = ApogyAddonsSensorsFOVFactory.eINSTANCE.createDistanceRange();
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsSensorsFOVPackage.Literals.RECTANGULAR_FRUSTRUM_FIELD_OF_VIEW__RANGE, (Object)tmp, true);
        }
        return tmp;
    }

    @Override
    public double getVolume() {
        if (this.getRange() != null) {
            double surfaceFraction = this.getHorizontalFieldOfViewAngle() * (Math.cos(0.0) - Math.cos(this.getVerticalFieldOfViewAngle())) / (Math.PI * 4);
            double largeVolume = 4.1887902047863905 * Math.pow(this.getRange().getMaximumDistance(), 3.0) * surfaceFraction;
            double smallVolume = 4.1887902047863905 * Math.pow(this.getRange().getMinimumDistance(), 3.0) * surfaceFraction;
            return largeVolume - smallVolume;
        }
        return 0.0;
    }

    @Override
    public boolean isPointVisible(Tuple3d point) {
        double x = point.getX();
        double y = point.getY();
        double z = point.getZ();
        double ryz = Math.sqrt(y * y + z * z);
        double vAngle = Math.atan2(x, ryz);
        double hAngle = Math.atan2(y, z);
        return Math.abs(vAngle) <= this.getVerticalFieldOfViewAngle() / 2.0 && Math.abs(hAngle) <= this.getHorizontalFieldOfViewAngle() / 2.0;
    }

    @Override
    public boolean isPointInside(Tuple3d point) {
        if (this.isPointVisible(point)) {
            double distance = Math.sqrt(point.getX() * point.getX() + point.getY() * point.getY() + point.getZ() * point.getZ());
            return this.getRange().isWithinRange(distance);
        }
        return false;
    }
}

