/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.orbit.planner.ui.parts;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.composites.AbstractECollectionComposite;
import org.eclipse.apogy.core.environment.earth.EarthOutlook;
import org.eclipse.apogy.core.environment.earth.orbit.EarthSpacecraft;
import org.eclipse.apogy.core.environment.earth.orbit.VisibilityPass;
import org.eclipse.apogy.core.environment.earth.orbit.planner.ApogyCoreEnvironmentEarthOrbitPlannerFacade;
import org.eclipse.apogy.core.environment.earth.orbit.planner.ObservationAnalysisPlanner;
import org.eclipse.apogy.core.environment.earth.orbit.planner.ObservationAnalysisPlannerNode;
import org.eclipse.apogy.core.environment.earth.orbit.planner.ui.composites.PlannerSolutionsComposite;
import org.eclipse.apogy.core.invocator.ui.parts.AbstractSessionECollectionPart;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;

public class PlannerSolutionsPart
extends AbstractSessionECollectionPart<ObservationAnalysisPlanner> {
    public static final String ID = "org.eclipse.apogy.core.environment.earth.orbit.planner.ui.parts.PlannerSolutionsPart";
    private static final String PARENT_PART_ID = "org.eclipse.apogy.core.environment.earth.orbit.planner.ui.parts.PlannersListPart";
    private PlannerSolutionsComposite composite;
    @Inject
    public ESelectionService selectionService;

    @Inject
    @Optional
    private void setSelection(@Named(value="org.eclipse.ui.selection") List<ObservationAnalysisPlanner> planners, EPartService partService) {
        if (partService != null && partService.getActivePart() != null && partService.getActivePart().getElementId().startsWith(PARENT_PART_ID)) {
            this.setContent((EObject)(planners == null || planners.isEmpty() || planners.size() > 1 ? null : planners.get(0)));
        }
    }

    @PostConstruct
    public void initialize() {
        this.setContent((EObject)((ObservationAnalysisPlanner)((IStructuredSelection)this.getParentSelection(PARENT_PART_ID)).getFirstElement()));
    }

    protected void doSetContent(ObservationAnalysisPlanner planner) {
        this.composite.setRootEObject((EObject)planner);
    }

    public AbstractECollectionComposite<?, ?, ?> createECollectionComposite(Composite parent, int style) {
        ECollectionCompositeSettings settings = ApogyCommonEMFUIFactory.eINSTANCE.createECollectionCompositeSettings();
        settings.setDetailSectionDisplayed(false);
        settings.setButtonsSectionDisplayed(true);
        this.composite = new PlannerSolutionsComposite(parent, 0, settings){

            protected void selectionChanged(IStructuredSelection selection) {
                PlannerSolutionsPart.this.selectionService.setSelection((Object)this.getSelectedItemObjects());
                if (this.getSelectedItemObjects() != null && !this.getSelectedItemObjects().isEmpty()) {
                    ArrayList<VisibilityPass> passes = new ArrayList<VisibilityPass>();
                    HashSet<EarthSpacecraft> spacecrafts = new HashSet<EarthSpacecraft>();
                    HashSet<EarthOutlook> outlooks = new HashSet<EarthOutlook>();
                    for (ObservationAnalysisPlannerNode solution : this.getSelectedItemObjects()) {
                        for (ObservationAnalysisPlannerNode node : ApogyCoreEnvironmentEarthOrbitPlannerFacade.INSTANCE.getPlannerSolution(solution).getEObjects()) {
                            passes.add(node.getPass());
                            spacecrafts.add(node.getPass().getSpacecraft());
                            outlooks.add(node.getPass().getOutlook());
                        }
                    }
                    PlannerSolutionsPart.this.selectionService.setSelection(passes);
                    PlannerSolutionsPart.this.selectionService.setSelection(new ArrayList(spacecrafts));
                    PlannerSolutionsPart.this.selectionService.setSelection(new ArrayList(outlooks));
                }
            }
        };
        return this.composite;
    }
}

