/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.fov.ui.wizards;

import org.eclipse.apogy.addons.sensors.fov.AngularSpan;
import org.eclipse.apogy.addons.sensors.fov.ui.composites.AngularSpanComposite;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class AngularSpanWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.addons.sensors.fov.ui.wizards.AngularSpanWizardPage";
    private final AngularSpan angularSpan;
    private AngularSpanComposite angularSpanComposite;
    private Adapter adapter;

    public AngularSpanWizardPage(AngularSpan angularSpan) {
        super(WIZARD_PAGE_ID);
        this.angularSpan = angularSpan;
        this.setTitle("Angular Span");
        this.setDescription("Sets the angular span minium and maximum angles.");
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, false));
        this.angularSpanComposite = new AngularSpanComposite(top, 0);
        this.angularSpanComposite.setAngularSpan(this.angularSpan);
        this.setControl((Control)top);
        if (this.angularSpan != null) {
            this.angularSpan.eAdapters().add((Object)this.getAdapter());
        }
        top.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (AngularSpanWizardPage.this.angularSpan != null) {
                    AngularSpanWizardPage.this.angularSpan.eAdapters().remove((Object)AngularSpanWizardPage.this.getAdapter());
                }
            }
        });
        this.validate();
    }

    protected void validate() {
        this.setErrorMessage(null);
        if (this.angularSpan.getMaximumAngle() <= this.angularSpan.getMinimumAngle()) {
            this.setErrorMessage("The specified maximum angle should equal or greater than the minimum angle !");
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    protected Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof AngularSpan) {
                        AngularSpanWizardPage.this.validate();
                    }
                }
            };
        }
        return this.adapter;
    }
}

