/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.fov.ui.impl;

import javax.vecmath.Point3d;
import org.eclipse.apogy.addons.sensors.fov.ConicalFieldOfView;
import org.eclipse.apogy.addons.sensors.fov.ui.Activator;
import org.eclipse.apogy.addons.sensors.fov.ui.impl.ConicalFieldOfViewPresentationImpl;
import org.eclipse.apogy.addons.sensors.fov.ui.scene_objects.ConicalFieldOfViewSceneObject;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.topology.ui.MeshPresentationMode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;

public class ConicalFieldOfViewPresentationCustomImpl
extends ConicalFieldOfViewPresentationImpl {
    protected ConicalFieldOfViewPresentationCustomImpl() {
        this.applyPreferences();
    }

    public Tuple3d basicGetCentroid() {
        Point3d point3d = new Point3d();
        if (this.getSceneObject() != null) {
            point3d = this.getSceneObject().getCentroid();
        }
        return ApogyCommonMathFacade.INSTANCE.createTuple3d((javax.vecmath.Tuple3d)point3d);
    }

    @Override
    public void setPresentationMode(MeshPresentationMode newPresentationMode) {
        super.setPresentationMode(newPresentationMode);
        if (this.getSceneObject() instanceof ConicalFieldOfViewSceneObject) {
            ConicalFieldOfViewSceneObject j3dObject = (ConicalFieldOfViewSceneObject)this.getSceneObject();
            j3dObject.setPresentationMode(newPresentationMode);
        }
    }

    @Override
    protected void initialSceneObject() {
        super.initialSceneObject();
    }

    public double getXRange() {
        ConicalFieldOfView fov = (ConicalFieldOfView)this.getNode();
        if (fov != null) {
            if (fov.getFieldOfViewAngle() < Math.PI) {
                return fov.getRange().getMaximumDistance() * Math.sqrt(2.0 - 2.0 * Math.cos(fov.getFieldOfViewAngle()));
            }
            return 2.0 * fov.getRange().getMaximumDistance();
        }
        return super.getXRange();
    }

    public double getYRange() {
        return this.getXRange();
    }

    public double getZRange() {
        ConicalFieldOfView fov = (ConicalFieldOfView)this.getNode();
        if (fov != null) {
            if (fov.getFieldOfViewAngle() < Math.PI) {
                double zMin = fov.getRange().getMinimumDistance() * Math.cos(fov.getFieldOfViewAngle() / 2.0);
                double zMax = fov.getRange().getMaximumDistance();
                return zMax - zMin;
            }
            return 2.0 * fov.getRange().getDistance();
        }
        return super.getZRange();
    }

    @Override
    protected void applyPreferences() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        this.setVisible(store.getBoolean("DEFAULT_CONICAL_VISIBILITY_ID"));
        this.setFovVisible(store.getBoolean("DEFAULT_CONICAL_FOV_VISIBILITY_ID"));
        this.setAxisVisible(store.getBoolean("DEFAULT_CONICAL_FOV_AXIS_VISIBLE_ID"));
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"DEFAULT_CONICAL_FOV_COLOR");
        if (rgb != null) {
            this.setColor(ApogyCommonEMFUIFacade.INSTANCE.convertToRGBA(rgb));
        }
        this.setShowOutlineOnly(store.getBoolean("DEFAULT_CONICAL_FOV_SHOW_OUTLINE_ONLY"));
        this.setShowProjection(store.getBoolean("DEFAULT_CONICAL_FOV_SHOW_PROJECTION_ID"));
        RGB projectionColorPref = PreferenceConverter.getColor((IPreferenceStore)store, (String)"DEFAULT_CONICAL_FOV_PROJECTION_COLOR_ID");
        if (projectionColorPref != null) {
            this.setProjectionColor(ApogyCommonEMFUIFacade.INSTANCE.convertToRGBA(projectionColorPref));
        }
        this.setPresentationMode(MeshPresentationMode.get((int)store.getInt("DEFAULT_CONICAL_FOV_PRESENTATION_MODE")));
        super.applyPreferences();
    }
}

