/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.surface.ui.databindings;

import java.util.Date;
import org.eclipse.apogy.core.environment.earth.surface.AstronomyUtils;
import org.eclipse.core.databinding.conversion.Converter;

public class DateToSideralTimeStringConverter
extends Converter {
    private double observerLongitude = 0.0;

    public DateToSideralTimeStringConverter() {
        super(Date.class, String.class);
    }

    public DateToSideralTimeStringConverter(double observerLongitude) {
        super(Date.class, String.class);
        this.setObserverLongitude(observerLongitude);
    }

    public double getObserverLongitude() {
        return this.observerLongitude;
    }

    public void setObserverLongitude(double observerLongitude) {
        this.observerLongitude = observerLongitude;
    }

    public Object convert(Object fromObject) {
        Date date = (Date)fromObject;
        double sideralTime = AstronomyUtils.INSTANCE.getLocalSideralTime(date, this.getObserverLongitude());
        return AstronomyUtils.INSTANCE.convertToHHmmssString(sideralTime);
    }
}

