/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.surface.ui.composites;

import java.util.Map;
import org.eclipse.apogy.core.environment.earth.surface.EarthSurfaceWorksite;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EarthSurfaceWorksiteImportFromFileComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(EarthSurfaceWorksiteImportFromFileComposite.class);
    public static String path = System.getProperty("user.home");
    private EarthSurfaceWorksite selectedEarthSurfaceWorksite;
    private final Button btnBrowse;
    private final Text text;

    public EarthSurfaceWorksiteImportFromFileComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(3, false));
        Label lblFile = new Label((Composite)this, 0);
        lblFile.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblFile.setText("File:");
        this.text = new Text((Composite)this, 2048);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.text.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    EarthSurfaceWorksiteImportFromFileComposite.this.loadEarthSurfaceWorksite(EarthSurfaceWorksiteImportFromFileComposite.this.text.getText());
                }
                catch (Throwable t) {
                    String errorMessage = "Failed to import Earth Surface Worksite from file<" + EarthSurfaceWorksiteImportFromFileComposite.this.text.getText() + ">!";
                    Logger.error(errorMessage, t);
                    MessageDialog.openError((Shell)EarthSurfaceWorksiteImportFromFileComposite.this.getShell(), (String)"Error", (String)errorMessage);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnBrowse = new Button((Composite)this, 0);
        this.btnBrowse.setText("Browse...");
        this.btnBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(EarthSurfaceWorksiteImportFromFileComposite.this.getShell(), 4096);
                fd.setFilterPath(path);
                fd.setFilterExtensions(new String[]{"*.ws", "*.sws"});
                fd.setOverwrite(true);
                String filePath = fd.open();
                if (filePath != null && filePath.length() > 0) {
                    try {
                        EarthSurfaceWorksiteImportFromFileComposite.this.loadEarthSurfaceWorksite(filePath);
                        EarthSurfaceWorksiteImportFromFileComposite.this.text.setText(filePath);
                    }
                    catch (Throwable t) {
                        EarthSurfaceWorksiteImportFromFileComposite.this.setSelectedEarthSurfaceWorksite(null);
                        String errorMessage = "Failed to import Earth Surface Worksite from file<" + filePath + ">!";
                        Logger.error(errorMessage, t);
                        MessageDialog.openError((Shell)EarthSurfaceWorksiteImportFromFileComposite.this.getShell(), (String)"Error", (String)errorMessage);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void setSelectedEarthSurfaceWorksite(EarthSurfaceWorksite selectedEarthSurfaceWorksite) {
        this.selectedEarthSurfaceWorksite = selectedEarthSurfaceWorksite;
        this.newEarthSurfaceWorksiteSelected(selectedEarthSurfaceWorksite);
    }

    public EarthSurfaceWorksite getSelectedEarthSurfaceWorksite() {
        return this.selectedEarthSurfaceWorksite;
    }

    private void loadEarthSurfaceWorksite(String filePath) throws Throwable {
        if (filePath != null) {
            String urlString = filePath;
            Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
            Map m = reg.getExtensionToFactoryMap();
            m.put("key", new XMIResourceFactoryImpl());
            ResourceSetImpl resSet = new ResourceSetImpl();
            Resource resource = resSet.createResource(URI.createFileURI((String)urlString));
            resource.load(m);
            EarthSurfaceWorksite earthSurfaceWorksite = (EarthSurfaceWorksite)resource.getContents().get(0);
            this.setSelectedEarthSurfaceWorksite(earthSurfaceWorksite);
        }
    }

    protected void newEarthSurfaceWorksiteSelected(EarthSurfaceWorksite earthSurfaceWorksite) {
    }
}

