/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class Activator
implements BundleActivator {
    private static BundleContext context;
    public static final String ID = "gov.nasa.worldwind";

    public static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        this.extractNativeLibraries();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
    }

    private void extractNativeLibraries() {
        this.log(ID, "Extract native libraries for " + Platform.getOS() + "." + Platform.getOSArch() + " started.", 1, null);
        try {
            if (Platform.getOS().equals("win32") && Platform.getOSArch().equals("x86")) {
                this.extractNativeLibraries("gluegen-rt-natives-windows-i586.jar", ".dll");
                this.extractNativeLibraries("jogl-all-natives-windows-i586.jar", ".dll");
            } else if (Platform.getOS().equals("win32") && Platform.getOSArch().equals("x86_64")) {
                this.extractNativeLibraries("gluegen-rt-natives-windows-amd64.jar", ".dll");
                this.extractNativeLibraries("jogl-all-natives-windows-amd64.jar", ".dll");
            } else if (Platform.getOS().equals("linux") && Platform.getOSArch().equals("x86")) {
                this.extractNativeLibraries("gluegen-rt-natives-linux-i586.jar", ".so");
                this.extractNativeLibraries("jogl-all-natives-linux-i586.jar", ".so");
            } else if (Platform.getOS().equals("linux") && Platform.getOSArch().equals("x86_64")) {
                this.extractNativeLibraries("gluegen-rt-natives-linux-amd64.jar", ".so");
                this.extractNativeLibraries("jogl-all-natives-linux-amd64.jar", ".so");
            } else if (Platform.getOS().equals("macosx")) {
                this.extractNativeLibraries("gluegen-rt-natives-macosx-universal.jar", ".jnilib");
                this.extractNativeLibraries("jogl-all-natives-macosx-universal.jar", ".jnilib");
            } else {
                throw new Exception("");
            }
            this.log(ID, "Extract native libraries for " + Platform.getOS() + "." + Platform.getOSArch() + " completed.", 1, null);
        }
        catch (Exception e) {
            this.log(ID, "Failed to extract native libraries for " + Platform.getOS() + "." + Platform.getOSArch() + " completed.", 4, null);
        }
    }

    public void log(String bundleId, String message, int severity, Throwable t) {
        String fullMessage = message;
        FrameworkLogEntry logEntry = new FrameworkLogEntry(bundleId, severity, 0, fullMessage, 0, t, null);
        this.getLog().log(logEntry);
    }

    public FrameworkLog getLog() {
        if (Activator.getContext() != null) {
            ServiceReference logService = Activator.getContext().getServiceReference("org.eclipse.osgi.framework.log.FrameworkLog");
            FrameworkLog log = (FrameworkLog)Activator.getContext().getService(logService);
            return log;
        }
        return null;
    }

    private void extractNativeLibraries(String jarFilename, String libraryExtension) throws Exception {
        Bundle bundle = FrameworkUtil.getBundle(Activator.class);
        URL url = bundle.getEntry("jars/" + jarFilename);
        try {
            ReadableByteChannel rbc = Channels.newChannel(url.openStream());
            FileOutputStream fos = new FileOutputStream(jarFilename);
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            fos.close();
        }
        catch (Exception e) {
            throw new Exception("Unable to open " + url, e);
        }
        try {
            File file = new File(jarFilename);
            JarFile jarFile = new JarFile(file);
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = jarEntries.nextElement();
                if (jarEntry.getName().indexOf(libraryExtension) == -1) continue;
                ReadableByteChannel rbc = Channels.newChannel(jarFile.getInputStream(jarEntry));
                File nativeFile = new File(jarEntry.getName());
                nativeFile.deleteOnExit();
                FileOutputStream fos = new FileOutputStream(nativeFile);
                fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                fos.close();
            }
            jarFile.close();
            file.delete();
        }
        catch (IOException e) {
            throw new Exception("Unable to extract native libaries (" + libraryExtension + ") from " + url, e);
        }
    }
}

