/*
 * Decompiled with CFR 0.152.
 */
package org.ros.message;

import com.google.common.base.Preconditions;
import org.ros.message.MessageIdentifier;

public class MessageDeclaration {
    private final MessageIdentifier messageIdentifier;
    private final String definition;

    public static MessageDeclaration of(String type, String definition) {
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull((Object)definition);
        return new MessageDeclaration(MessageIdentifier.of(type), definition);
    }

    public MessageDeclaration(MessageIdentifier messageIdentifier, String definition) {
        Preconditions.checkNotNull((Object)messageIdentifier);
        Preconditions.checkNotNull((Object)definition);
        this.messageIdentifier = messageIdentifier;
        this.definition = definition;
    }

    public MessageIdentifier getMessageIdentifier() {
        return this.messageIdentifier;
    }

    public String getType() {
        return this.messageIdentifier.getType();
    }

    public String getPackage() {
        return this.messageIdentifier.getPackage();
    }

    public String getName() {
        return this.messageIdentifier.getName();
    }

    public String getDefinition() {
        Preconditions.checkNotNull((Object)this.definition);
        return this.definition;
    }

    public String toString() {
        return String.format("MessageDeclaration<%s>", this.messageIdentifier.toString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.definition == null ? 0 : this.definition.hashCode());
        result = 31 * result + (this.messageIdentifier == null ? 0 : this.messageIdentifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessageDeclaration other = (MessageDeclaration)obj;
        if (this.definition == null ? other.definition != null : !this.definition.equals(other.definition)) {
            return false;
        }
        return !(this.messageIdentifier == null ? other.messageIdentifier != null : !this.messageIdentifier.equals(other.messageIdentifier));
    }
}

