/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.message.field;

import org.jboss.netty.buffer.ChannelBuffer;
import org.ros.internal.message.field.FieldType;

public abstract class Field {
    protected final FieldType type;
    protected final String name;
    protected final boolean isConstant;

    protected Field(FieldType type, String name, boolean isConstant) {
        this.name = name;
        this.type = type;
        this.isConstant = isConstant;
    }

    public String getName() {
        return this.name;
    }

    public FieldType getType() {
        return this.type;
    }

    public boolean isConstant() {
        return this.isConstant;
    }

    public String getMd5String() {
        if (this.isConstant()) {
            return String.format("%s %s=%s\n", this.getType().getMd5String(), this.getName(), this.getValue());
        }
        return String.format("%s %s\n", this.getType().getMd5String(), this.getName());
    }

    public abstract void serialize(ChannelBuffer var1);

    public abstract void deserialize(ChannelBuffer var1);

    public abstract <T> T getValue();

    public abstract void setValue(Object var1);

    public abstract String getJavaTypeName();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isConstant ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Field other = (Field)obj;
        if (this.isConstant != other.isConstant) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

