/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.message.field;

import com.google.common.base.Preconditions;
import java.nio.ByteOrder;
import org.jboss.netty.buffer.ChannelBuffer;
import org.ros.internal.message.MessageBuffers;
import org.ros.internal.message.field.Field;
import org.ros.internal.message.field.FieldType;

public class ChannelBufferField
extends Field {
    private final int size;
    private ChannelBuffer value;

    public static ChannelBufferField newVariable(FieldType type, String name, int size) {
        return new ChannelBufferField(type, name, size);
    }

    private ChannelBufferField(FieldType type, String name, int size) {
        super(type, name, false);
        this.size = size;
        this.value = MessageBuffers.dynamicBuffer();
    }

    public ChannelBuffer getValue() {
        return this.value.duplicate();
    }

    @Override
    public void setValue(Object value) {
        Preconditions.checkArgument((((ChannelBuffer)value).order() == ByteOrder.LITTLE_ENDIAN ? 1 : 0) != 0);
        Preconditions.checkArgument((this.size < 0 || ((ChannelBuffer)value).readableBytes() == this.size ? 1 : 0) != 0);
        this.value = (ChannelBuffer)value;
    }

    @Override
    public void serialize(ChannelBuffer buffer) {
        if (this.size < 0) {
            buffer.writeInt(this.value.readableBytes());
        }
        buffer.writeBytes(this.value, 0, this.value.readableBytes());
    }

    @Override
    public void deserialize(ChannelBuffer buffer) {
        int currentSize = this.size;
        if (currentSize < 0) {
            currentSize = buffer.readInt();
        }
        this.value = buffer.readSlice(currentSize);
    }

    @Override
    public String getMd5String() {
        return String.format("%s %s\n", this.type, this.name);
    }

    @Override
    public String getJavaTypeName() {
        return "org.jboss.netty.buffer.ChannelBuffer";
    }

    public String toString() {
        return "ChannelBufferField<" + this.type + ", " + this.name + ">";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChannelBufferField other = (ChannelBufferField)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }
}

